<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddGeofenceSet StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddGeofenceSet
 * @package Pcm
 * @subpackage Structs
 */
class PcmAddGeofenceSet extends AbstractStructBase
{
    /**
     * The ActiveState
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActiveState;
    /**
     * The BorderAlpha
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BorderAlpha;
    /**
     * The BorderColor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BorderColor;
    /**
     * The BorderWidth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BorderWidth;
    /**
     * The EndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndTime;
    /**
     * The FillAlpha
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FillAlpha;
    /**
     * The FillColor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FillColor;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartTime;
    /**
     * The Tag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tag;
    /**
     * The Visible
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Visible;
    /**
     * Constructor method for AddGeofenceSet
     * @uses PcmAddGeofenceSet::setActiveState()
     * @uses PcmAddGeofenceSet::setBorderAlpha()
     * @uses PcmAddGeofenceSet::setBorderColor()
     * @uses PcmAddGeofenceSet::setBorderWidth()
     * @uses PcmAddGeofenceSet::setEndTime()
     * @uses PcmAddGeofenceSet::setFillAlpha()
     * @uses PcmAddGeofenceSet::setFillColor()
     * @uses PcmAddGeofenceSet::setName()
     * @uses PcmAddGeofenceSet::setStartTime()
     * @uses PcmAddGeofenceSet::setTag()
     * @uses PcmAddGeofenceSet::setVisible()
     * @param string $activeState
     * @param string $borderAlpha
     * @param int $borderColor
     * @param string $borderWidth
     * @param string $endTime
     * @param string $fillAlpha
     * @param int $fillColor
     * @param string $name
     * @param string $startTime
     * @param string $tag
     * @param bool $visible
     */
    public function __construct($activeState = null, $borderAlpha = null, $borderColor = null, $borderWidth = null, $endTime = null, $fillAlpha = null, $fillColor = null, $name = null, $startTime = null, $tag = null, $visible = null)
    {
        $this
            ->setActiveState($activeState)
            ->setBorderAlpha($borderAlpha)
            ->setBorderColor($borderColor)
            ->setBorderWidth($borderWidth)
            ->setEndTime($endTime)
            ->setFillAlpha($fillAlpha)
            ->setFillColor($fillColor)
            ->setName($name)
            ->setStartTime($startTime)
            ->setTag($tag)
            ->setVisible($visible);
    }
    /**
     * Get ActiveState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActiveState()
    {
        return isset($this->ActiveState) ? $this->ActiveState : null;
    }
    /**
     * Set ActiveState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pcm\EnumType\PcmGeofenceState::valueIsValid()
     * @uses \Pcm\EnumType\PcmGeofenceState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activeState
     * @return \Pcm\StructType\PcmAddGeofenceSet
     */
    public function setActiveState($activeState = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmGeofenceState::valueIsValid($activeState)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $activeState, implode(', ', \Pcm\EnumType\PcmGeofenceState::getValidValues())), __LINE__);
        }
        if (is_null($activeState) || (is_array($activeState) && empty($activeState))) {
            unset($this->ActiveState);
        } else {
            $this->ActiveState = $activeState;
        }
        return $this;
    }
    /**
     * Get BorderAlpha value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBorderAlpha()
    {
        return isset($this->BorderAlpha) ? $this->BorderAlpha : null;
    }
    /**
     * Set BorderAlpha value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $borderAlpha
     * @return \Pcm\StructType\PcmAddGeofenceSet
     */
    public function setBorderAlpha($borderAlpha = null)
    {
        // validation for constraint: string
        if (!is_null($borderAlpha) && !is_string($borderAlpha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($borderAlpha)), __LINE__);
        }
        if (is_null($borderAlpha) || (is_array($borderAlpha) && empty($borderAlpha))) {
            unset($this->BorderAlpha);
        } else {
            $this->BorderAlpha = $borderAlpha;
        }
        return $this;
    }
    /**
     * Get BorderColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBorderColor()
    {
        return isset($this->BorderColor) ? $this->BorderColor : null;
    }
    /**
     * Set BorderColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $borderColor
     * @return \Pcm\StructType\PcmAddGeofenceSet
     */
    public function setBorderColor($borderColor = null)
    {
        // validation for constraint: int
        if (!is_null($borderColor) && !is_numeric($borderColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($borderColor)), __LINE__);
        }
        if (is_null($borderColor) || (is_array($borderColor) && empty($borderColor))) {
            unset($this->BorderColor);
        } else {
            $this->BorderColor = $borderColor;
        }
        return $this;
    }
    /**
     * Get BorderWidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBorderWidth()
    {
        return isset($this->BorderWidth) ? $this->BorderWidth : null;
    }
    /**
     * Set BorderWidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $borderWidth
     * @return \Pcm\StructType\PcmAddGeofenceSet
     */
    public function setBorderWidth($borderWidth = null)
    {
        // validation for constraint: string
        if (!is_null($borderWidth) && !is_string($borderWidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($borderWidth)), __LINE__);
        }
        if (is_null($borderWidth) || (is_array($borderWidth) && empty($borderWidth))) {
            unset($this->BorderWidth);
        } else {
            $this->BorderWidth = $borderWidth;
        }
        return $this;
    }
    /**
     * Get EndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndTime()
    {
        return isset($this->EndTime) ? $this->EndTime : null;
    }
    /**
     * Set EndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endTime
     * @return \Pcm\StructType\PcmAddGeofenceSet
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        if (is_null($endTime) || (is_array($endTime) && empty($endTime))) {
            unset($this->EndTime);
        } else {
            $this->EndTime = $endTime;
        }
        return $this;
    }
    /**
     * Get FillAlpha value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFillAlpha()
    {
        return isset($this->FillAlpha) ? $this->FillAlpha : null;
    }
    /**
     * Set FillAlpha value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fillAlpha
     * @return \Pcm\StructType\PcmAddGeofenceSet
     */
    public function setFillAlpha($fillAlpha = null)
    {
        // validation for constraint: string
        if (!is_null($fillAlpha) && !is_string($fillAlpha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fillAlpha)), __LINE__);
        }
        if (is_null($fillAlpha) || (is_array($fillAlpha) && empty($fillAlpha))) {
            unset($this->FillAlpha);
        } else {
            $this->FillAlpha = $fillAlpha;
        }
        return $this;
    }
    /**
     * Get FillColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFillColor()
    {
        return isset($this->FillColor) ? $this->FillColor : null;
    }
    /**
     * Set FillColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fillColor
     * @return \Pcm\StructType\PcmAddGeofenceSet
     */
    public function setFillColor($fillColor = null)
    {
        // validation for constraint: int
        if (!is_null($fillColor) && !is_numeric($fillColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fillColor)), __LINE__);
        }
        if (is_null($fillColor) || (is_array($fillColor) && empty($fillColor))) {
            unset($this->FillColor);
        } else {
            $this->FillColor = $fillColor;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \Pcm\StructType\PcmAddGeofenceSet
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get StartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartTime()
    {
        return isset($this->StartTime) ? $this->StartTime : null;
    }
    /**
     * Set StartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startTime
     * @return \Pcm\StructType\PcmAddGeofenceSet
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        if (is_null($startTime) || (is_array($startTime) && empty($startTime))) {
            unset($this->StartTime);
        } else {
            $this->StartTime = $startTime;
        }
        return $this;
    }
    /**
     * Get Tag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTag()
    {
        return isset($this->Tag) ? $this->Tag : null;
    }
    /**
     * Set Tag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tag
     * @return \Pcm\StructType\PcmAddGeofenceSet
     */
    public function setTag($tag = null)
    {
        // validation for constraint: string
        if (!is_null($tag) && !is_string($tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tag)), __LINE__);
        }
        if (is_null($tag) || (is_array($tag) && empty($tag))) {
            unset($this->Tag);
        } else {
            $this->Tag = $tag;
        }
        return $this;
    }
    /**
     * Get Visible value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisible()
    {
        return isset($this->Visible) ? $this->Visible : null;
    }
    /**
     * Set Visible value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visible
     * @return \Pcm\StructType\PcmAddGeofenceSet
     */
    public function setVisible($visible = null)
    {
        if (is_null($visible) || (is_array($visible) && empty($visible))) {
            unset($this->Visible);
        } else {
            $this->Visible = $visible;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmAddGeofenceSet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
