<?php

namespace Pcm;

/**
 * Class which returns the class map definition
 * @package Pcm
 */
class PcmClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'ArrayOfKeyValuePairOfstringstring' => '\\Pcm\\ArrayType\\PcmArrayOfKeyValuePairOfstringstring',
            'KeyValuePairOfstringstring' => '\\Pcm\\StructType\\PcmKeyValuePairOfstringstring',
            'ArrayOfint' => '\\Pcm\\ArrayType\\PcmArrayOfint',
            'ArrayOfstring' => '\\Pcm\\ArrayType\\PcmArrayOfstring',
            'ArrayOfArrayOfdouble' => '\\Pcm\\ArrayType\\PcmArrayOfArrayOfdouble',
            'ArrayOfdouble' => '\\Pcm\\ArrayType\\PcmArrayOfdouble',
            'ArrayOfArrayOfArrayOfdouble' => '\\Pcm\\ArrayType\\PcmArrayOfArrayOfArrayOfdouble',
            'ArrayOfArrayOfint' => '\\Pcm\\ArrayType\\PcmArrayOfArrayOfint',
            'AFExtraInfo' => '\\Pcm\\StructType\\PcmAFExtraInfo',
            'AboutService' => '\\Pcm\\StructType\\PcmAboutService',
            'Request' => '\\Pcm\\StructType\\PcmRequest',
            'RequestHeader' => '\\Pcm\\StructType\\PcmRequestHeader',
            'ServiceRequestHeader' => '\\Pcm\\StructType\\PcmServiceRequestHeader',
            'AboutServiceResponse' => '\\Pcm\\StructType\\PcmAboutServiceResponse',
            'Response' => '\\Pcm\\StructType\\PcmResponse',
            'ResponseHeader' => '\\Pcm\\StructType\\PcmResponseHeader',
            'ArrayOfError' => '\\Pcm\\ArrayType\\PcmArrayOfError',
            'Error' => '\\Pcm\\StructType\\PcmError',
            'ProcessGeocode' => '\\Pcm\\StructType\\PcmProcessGeocode',
            'GeocodeRequest' => '\\Pcm\\StructType\\PcmGeocodeRequest',
            'GeocodeRequestBody' => '\\Pcm\\StructType\\PcmGeocodeRequestBody',
            'ArrayOfGeocodeLocation' => '\\Pcm\\ArrayType\\PcmArrayOfGeocodeLocation',
            'GeocodeLocation' => '\\Pcm\\StructType\\PcmGeocodeLocation',
            'Address' => '\\Pcm\\StructType\\PcmAddress',
            'ProcessGeocodeResponse' => '\\Pcm\\StructType\\PcmProcessGeocodeResponse',
            'GeocodeResponse' => '\\Pcm\\StructType\\PcmGeocodeResponse',
            'GeocodeResponseBody' => '\\Pcm\\StructType\\PcmGeocodeResponseBody',
            'ArrayOfGeocodeOutputLocation' => '\\Pcm\\ArrayType\\PcmArrayOfGeocodeOutputLocation',
            'GeocodeOutputLocation' => '\\Pcm\\StructType\\PcmGeocodeOutputLocation',
            'Location' => '\\Pcm\\StructType\\PcmLocation',
            'Coordinates' => '\\Pcm\\StructType\\PcmCoordinates',
            'SpeedLimit' => '\\Pcm\\StructType\\PcmSpeedLimit',
            'ProcessReverseGeocode' => '\\Pcm\\StructType\\PcmProcessReverseGeocode',
            'ReverseGeocodeRequest' => '\\Pcm\\StructType\\PcmReverseGeocodeRequest',
            'ReverseGeocodeRequestBody' => '\\Pcm\\StructType\\PcmReverseGeocodeRequestBody',
            'ArrayOfReverseGeoCoord' => '\\Pcm\\ArrayType\\PcmArrayOfReverseGeoCoord',
            'ReverseGeoCoord' => '\\Pcm\\StructType\\PcmReverseGeoCoord',
            'SpeedLimitOptions' => '\\Pcm\\StructType\\PcmSpeedLimitOptions',
            'ProcessReverseGeocodeResponse' => '\\Pcm\\StructType\\PcmProcessReverseGeocodeResponse',
            'ProcessRadiusSearch' => '\\Pcm\\StructType\\PcmProcessRadiusSearch',
            'RadiusSearchRequest' => '\\Pcm\\StructType\\PcmRadiusSearchRequest',
            'RadiusSearchRequestBody' => '\\Pcm\\StructType\\PcmRadiusSearchRequestBody',
            'Distance' => '\\Pcm\\StructType\\PcmDistance',
            'ProcessRadiusSearchResponse' => '\\Pcm\\StructType\\PcmProcessRadiusSearchResponse',
            'RadiusSearchResponse' => '\\Pcm\\StructType\\PcmRadiusSearchResponse',
            'RadiusSearchResponseBody' => '\\Pcm\\StructType\\PcmRadiusSearchResponseBody',
            'ArrayOfRadiusSearchMatch' => '\\Pcm\\ArrayType\\PcmArrayOfRadiusSearchMatch',
            'RadiusSearchMatch' => '\\Pcm\\StructType\\PcmRadiusSearchMatch',
            'ProcessStates' => '\\Pcm\\StructType\\PcmProcessStates',
            'GetStatesRequest' => '\\Pcm\\StructType\\PcmGetStatesRequest',
            'GetStatesRequestBody' => '\\Pcm\\StructType\\PcmGetStatesRequestBody',
            'ProcessStatesResponse' => '\\Pcm\\StructType\\PcmProcessStatesResponse',
            'GetStatesResponse' => '\\Pcm\\StructType\\PcmGetStatesResponse',
            'GetStatesResponseBody' => '\\Pcm\\StructType\\PcmGetStatesResponseBody',
            'ArrayOfStateCountry' => '\\Pcm\\ArrayType\\PcmArrayOfStateCountry',
            'StateCountry' => '\\Pcm\\StructType\\PcmStateCountry',
            'GetAvoidFavor' => '\\Pcm\\StructType\\PcmGetAvoidFavor',
            'AvoidFavorRequest' => '\\Pcm\\StructType\\PcmAvoidFavorRequest',
            'AvoidFavorRequestBody' => '\\Pcm\\StructType\\PcmAvoidFavorRequestBody',
            'GetAvoidFavorResponse' => '\\Pcm\\StructType\\PcmGetAvoidFavorResponse',
            'AvoidFavorResponse' => '\\Pcm\\StructType\\PcmAvoidFavorResponse',
            'AvoidFavorResponseBody' => '\\Pcm\\StructType\\PcmAvoidFavorResponseBody',
            'ArrayOfAvoidFavor' => '\\Pcm\\ArrayType\\PcmArrayOfAvoidFavor',
            'AvoidFavor' => '\\Pcm\\StructType\\PcmAvoidFavor',
            'SetAvoidFavor' => '\\Pcm\\StructType\\PcmSetAvoidFavor',
            'SetAvoidFavorRequest' => '\\Pcm\\StructType\\PcmSetAvoidFavorRequest',
            'SetAvoidFavorRequestBody' => '\\Pcm\\StructType\\PcmSetAvoidFavorRequestBody',
            'ArrayOfAvoidFavorSet' => '\\Pcm\\ArrayType\\PcmArrayOfAvoidFavorSet',
            'AvoidFavorSet' => '\\Pcm\\StructType\\PcmAvoidFavorSet',
            'SetAvoidFavorResponse' => '\\Pcm\\StructType\\PcmSetAvoidFavorResponse',
            'GetCustomPlaces' => '\\Pcm\\StructType\\PcmGetCustomPlaces',
            'CustomPlaceRequest' => '\\Pcm\\StructType\\PcmCustomPlaceRequest',
            'CustomPlaceRequestBody' => '\\Pcm\\StructType\\PcmCustomPlaceRequestBody',
            'GetCustomPlacesResponse' => '\\Pcm\\StructType\\PcmGetCustomPlacesResponse',
            'CustomPlaceResponse' => '\\Pcm\\StructType\\PcmCustomPlaceResponse',
            'CustomPlaceResponseBody' => '\\Pcm\\StructType\\PcmCustomPlaceResponseBody',
            'ArrayOfLocation' => '\\Pcm\\ArrayType\\PcmArrayOfLocation',
            'SetCustomPlaces' => '\\Pcm\\StructType\\PcmSetCustomPlaces',
            'SetCustomPlaceRequest' => '\\Pcm\\StructType\\PcmSetCustomPlaceRequest',
            'SetCustomPlaceRequestBody' => '\\Pcm\\StructType\\PcmSetCustomPlaceRequestBody',
            'ArrayOfCustomPlaceLocation' => '\\Pcm\\ArrayType\\PcmArrayOfCustomPlaceLocation',
            'CustomPlaceLocation' => '\\Pcm\\StructType\\PcmCustomPlaceLocation',
            'SetCustomPlacesResponse' => '\\Pcm\\StructType\\PcmSetCustomPlacesResponse',
            'GetRoadSpeeds' => '\\Pcm\\StructType\\PcmGetRoadSpeeds',
            'RoadSpeedsRequest' => '\\Pcm\\StructType\\PcmRoadSpeedsRequest',
            'RoadSpeedsRequestBody' => '\\Pcm\\StructType\\PcmRoadSpeedsRequestBody',
            'GetRoadSpeedsResponse' => '\\Pcm\\StructType\\PcmGetRoadSpeedsResponse',
            'RoadSpeedsResponse' => '\\Pcm\\StructType\\PcmRoadSpeedsResponse',
            'RoadSpeedsResponseBody' => '\\Pcm\\StructType\\PcmRoadSpeedsResponseBody',
            'ArrayOfRoadSpeed' => '\\Pcm\\ArrayType\\PcmArrayOfRoadSpeed',
            'RoadSpeed' => '\\Pcm\\StructType\\PcmRoadSpeed',
            'RoadSpeedBase' => '\\Pcm\\StructType\\PcmRoadSpeedBase',
            'SetRoadSpeeds' => '\\Pcm\\StructType\\PcmSetRoadSpeeds',
            'SetRoadSpeedsRequest' => '\\Pcm\\StructType\\PcmSetRoadSpeedsRequest',
            'SetRoadSpeedsRequestBody' => '\\Pcm\\StructType\\PcmSetRoadSpeedsRequestBody',
            'SetRoadSpeedsResponse' => '\\Pcm\\StructType\\PcmSetRoadSpeedsResponse',
            'GetETAOutOfRouteReport' => '\\Pcm\\StructType\\PcmGetETAOutOfRouteReport',
            'ETAOutOfRouteRequest' => '\\Pcm\\StructType\\PcmETAOutOfRouteRequest',
            'ETAOutOfRouteRequestBody' => '\\Pcm\\StructType\\PcmETAOutOfRouteRequestBody',
            'StopLocation' => '\\Pcm\\StructType\\PcmStopLocation',
            'StopCosts' => '\\Pcm\\StructType\\PcmStopCosts',
            'ArrayOfStopLocation' => '\\Pcm\\ArrayType\\PcmArrayOfStopLocation',
            'RouteOptions' => '\\Pcm\\StructType\\PcmRouteOptions',
            'ArrayOfRoadSpeedBase' => '\\Pcm\\ArrayType\\PcmArrayOfRoadSpeedBase',
            'HoursOfServiceOptions' => '\\Pcm\\StructType\\PcmHoursOfServiceOptions',
            'TrailerConfig' => '\\Pcm\\StructType\\PcmTrailerConfig',
            'EngineConfig' => '\\Pcm\\StructType\\PcmEngineConfig',
            'TruckConfig' => '\\Pcm\\StructType\\PcmTruckConfig',
            'ReportOptions' => '\\Pcm\\StructType\\PcmReportOptions',
            'SharedOptions' => '\\Pcm\\StructType\\PcmSharedOptions',
            'EstimatedTimeOptions' => '\\Pcm\\StructType\\PcmEstimatedTimeOptions',
            'DateTimeType' => '\\Pcm\\StructType\\PcmDateTimeType',
            'RouteCosts' => '\\Pcm\\StructType\\PcmRouteCosts',
            'TimeCosts' => '\\Pcm\\StructType\\PcmTimeCosts',
            'TimeOfDay' => '\\Pcm\\StructType\\PcmTimeOfDay',
            'GetETAOutOfRouteReportResponse' => '\\Pcm\\StructType\\PcmGetETAOutOfRouteReportResponse',
            'ReportResponse' => '\\Pcm\\StructType\\PcmReportResponse',
            'ReportResponseBody' => '\\Pcm\\StructType\\PcmReportResponseBody',
            'ArrayOfReport' => '\\Pcm\\ArrayType\\PcmArrayOfReport',
            'Report' => '\\Pcm\\StructType\\PcmReport',
            'ETAOutOfRouteReport' => '\\Pcm\\StructType\\PcmETAOutOfRouteReport',
            'ArrayOfOutOfRouteReportLine' => '\\Pcm\\ArrayType\\PcmArrayOfOutOfRouteReportLine',
            'OutOfRouteReportLine' => '\\Pcm\\StructType\\PcmOutOfRouteReportLine',
            'MileageReport' => '\\Pcm\\StructType\\PcmMileageReport',
            'ArrayOfStopReportLine' => '\\Pcm\\ArrayType\\PcmArrayOfStopReportLine',
            'StopReportLine' => '\\Pcm\\StructType\\PcmStopReportLine',
            'DetailReport' => '\\Pcm\\StructType\\PcmDetailReport',
            'ArrayOfDetailReportLeg' => '\\Pcm\\ArrayType\\PcmArrayOfDetailReportLeg',
            'DetailReportLeg' => '\\Pcm\\StructType\\PcmDetailReportLeg',
            'ArrayOfDetailReportLine' => '\\Pcm\\ArrayType\\PcmArrayOfDetailReportLine',
            'DetailReportLine' => '\\Pcm\\StructType\\PcmDetailReportLine',
            'CalculateMilesReport' => '\\Pcm\\StructType\\PcmCalculateMilesReport',
            'DirectionsReport' => '\\Pcm\\StructType\\PcmDirectionsReport',
            'ArrayOfDirectionsReportLeg' => '\\Pcm\\ArrayType\\PcmArrayOfDirectionsReportLeg',
            'DirectionsReportLeg' => '\\Pcm\\StructType\\PcmDirectionsReportLeg',
            'ArrayOfDirectionsReportLine' => '\\Pcm\\ArrayType\\PcmArrayOfDirectionsReportLine',
            'DirectionsReportLine' => '\\Pcm\\StructType\\PcmDirectionsReportLine',
            'FuelReport' => '\\Pcm\\StructType\\PcmFuelReport',
            'ArrayOfFuelStopLine' => '\\Pcm\\ArrayType\\PcmArrayOfFuelStopLine',
            'FuelStopLine' => '\\Pcm\\StructType\\PcmFuelStopLine',
            'FuelReportSummary' => '\\Pcm\\StructType\\PcmFuelReportSummary',
            'GeoTunnelReport' => '\\Pcm\\StructType\\PcmGeoTunnelReport',
            'ArrayOfCoordinates' => '\\Pcm\\ArrayType\\PcmArrayOfCoordinates',
            'LeastCostReport' => '\\Pcm\\StructType\\PcmLeastCostReport',
            'ArrayOfComparisonReportLine' => '\\Pcm\\ArrayType\\PcmArrayOfComparisonReportLine',
            'ComparisonReportLine' => '\\Pcm\\StructType\\PcmComparisonReportLine',
            'RoadReport' => '\\Pcm\\StructType\\PcmRoadReport',
            'ArrayOfRoadReportLine' => '\\Pcm\\ArrayType\\PcmArrayOfRoadReportLine',
            'RoadReportLine' => '\\Pcm\\StructType\\PcmRoadReportLine',
            'StateReport' => '\\Pcm\\StructType\\PcmStateReport',
            'ArrayOfStateCostReportLine' => '\\Pcm\\ArrayType\\PcmArrayOfStateCostReportLine',
            'StateCostReportLine' => '\\Pcm\\StructType\\PcmStateCostReportLine',
            'WeatherAlertsReport' => '\\Pcm\\StructType\\PcmWeatherAlertsReport',
            'ArrayOfWeatherAlertEvent' => '\\Pcm\\ArrayType\\PcmArrayOfWeatherAlertEvent',
            'WeatherAlertEvent' => '\\Pcm\\StructType\\PcmWeatherAlertEvent',
            'TollDetailReport' => '\\Pcm\\StructType\\PcmTollDetailReport',
            'ArrayOfTollDetailReportSegmentLine' => '\\Pcm\\ArrayType\\PcmArrayOfTollDetailReportSegmentLine',
            'TollDetailReportSegmentLine' => '\\Pcm\\StructType\\PcmTollDetailReportSegmentLine',
            'ArrayOfTollDetailReportSummaryLine' => '\\Pcm\\ArrayType\\PcmArrayOfTollDetailReportSummaryLine',
            'TollDetailReportSummaryLine' => '\\Pcm\\StructType\\PcmTollDetailReportSummaryLine',
            'ReduceTrip' => '\\Pcm\\StructType\\PcmReduceTrip',
            'ReduceTripRequest' => '\\Pcm\\StructType\\PcmReduceTripRequest',
            'ReduceTripRequestBody' => '\\Pcm\\StructType\\PcmReduceTripRequestBody',
            'ReportType' => '\\Pcm\\StructType\\PcmReportType',
            'MileageReportType' => '\\Pcm\\StructType\\PcmMileageReportType',
            'DetailReportType' => '\\Pcm\\StructType\\PcmDetailReportType',
            'CalculateMilesReportType' => '\\Pcm\\StructType\\PcmCalculateMilesReportType',
            'DirectionsReportType' => '\\Pcm\\StructType\\PcmDirectionsReportType',
            'FuelReportType' => '\\Pcm\\StructType\\PcmFuelReportType',
            'GeoTunnelReportType' => '\\Pcm\\StructType\\PcmGeoTunnelReportType',
            'LeastCostReportType' => '\\Pcm\\StructType\\PcmLeastCostReportType',
            'RoadReportType' => '\\Pcm\\StructType\\PcmRoadReportType',
            'StateReportType' => '\\Pcm\\StructType\\PcmStateReportType',
            'WeatherAlertsReportType' => '\\Pcm\\StructType\\PcmWeatherAlertsReportType',
            'TollDetailReportType' => '\\Pcm\\StructType\\PcmTollDetailReportType',
            'ReduceTripResponse' => '\\Pcm\\StructType\\PcmReduceTripResponse',
            'GetReports' => '\\Pcm\\StructType\\PcmGetReports',
            'ReportRequest' => '\\Pcm\\StructType\\PcmReportRequest',
            'ReportRequestBody' => '\\Pcm\\StructType\\PcmReportRequestBody',
            'ArrayOfReportRoute' => '\\Pcm\\ArrayType\\PcmArrayOfReportRoute',
            'ReportRoute' => '\\Pcm\\StructType\\PcmReportRoute',
            'Route' => '\\Pcm\\StructType\\PcmRoute',
            'FuelOptions' => '\\Pcm\\StructType\\PcmFuelOptions',
            'ArrayOfReportType' => '\\Pcm\\ArrayType\\PcmArrayOfReportType',
            'GetReportsResponse' => '\\Pcm\\StructType\\PcmGetReportsResponse',
            'GetReportsLegacy' => '\\Pcm\\StructType\\PcmGetReportsLegacy',
            'ReportRequestLegacy' => '\\Pcm\\StructType\\PcmReportRequestLegacy',
            'ReportRequestBodyLegacy' => '\\Pcm\\StructType\\PcmReportRequestBodyLegacy',
            'ArrayOfReportRouteLegacy' => '\\Pcm\\ArrayType\\PcmArrayOfReportRouteLegacy',
            'ReportRouteLegacy' => '\\Pcm\\StructType\\PcmReportRouteLegacy',
            'GetReportsLegacyResponse' => '\\Pcm\\StructType\\PcmGetReportsLegacyResponse',
            'ReportResponseLegacy' => '\\Pcm\\StructType\\PcmReportResponseLegacy',
            'ReportResponseBodyLegacy' => '\\Pcm\\StructType\\PcmReportResponseBodyLegacy',
            'ArrayOfMileageReport' => '\\Pcm\\ArrayType\\PcmArrayOfMileageReport',
            'ArrayOfDetailReport' => '\\Pcm\\ArrayType\\PcmArrayOfDetailReport',
            'ArrayOfDirectionsReport' => '\\Pcm\\ArrayType\\PcmArrayOfDirectionsReport',
            'ArrayOfRoadReport' => '\\Pcm\\ArrayType\\PcmArrayOfRoadReport',
            'ArrayOfStateReport' => '\\Pcm\\ArrayType\\PcmArrayOfStateReport',
            'ArrayOfLeastCostReport' => '\\Pcm\\ArrayType\\PcmArrayOfLeastCostReport',
            'ArrayOfGeoTunnelReport' => '\\Pcm\\ArrayType\\PcmArrayOfGeoTunnelReport',
            'ArrayOfWeatherAlertsReport' => '\\Pcm\\ArrayType\\PcmArrayOfWeatherAlertsReport',
            'ArrayOfCalculateMilesReport' => '\\Pcm\\ArrayType\\PcmArrayOfCalculateMilesReport',
            'CreateRouteSyncMessage' => '\\Pcm\\StructType\\PcmCreateRouteSyncMessage',
            'CreateRouteSyncMsgRequest' => '\\Pcm\\StructType\\PcmCreateRouteSyncMsgRequest',
            'CreateRouteSyncMsgRequestBody' => '\\Pcm\\StructType\\PcmCreateRouteSyncMsgRequestBody',
            'ExtendedRoute' => '\\Pcm\\StructType\\PcmExtendedRoute',
            'CreateRouteSyncMessageResponse' => '\\Pcm\\StructType\\PcmCreateRouteSyncMessageResponse',
            'CreateRouteSyncMsgResponse' => '\\Pcm\\StructType\\PcmCreateRouteSyncMsgResponse',
            'CreateRouteSyncMsgResponseBody' => '\\Pcm\\StructType\\PcmCreateRouteSyncMsgResponseBody',
            'CreateTripInsightMessage' => '\\Pcm\\StructType\\PcmCreateTripInsightMessage',
            'CreateTripInsightMsgRequest' => '\\Pcm\\StructType\\PcmCreateTripInsightMsgRequest',
            'CreateTripInsightMsgRequestBody' => '\\Pcm\\StructType\\PcmCreateTripInsightMsgRequestBody',
            'CreateTripInsightMessageResponse' => '\\Pcm\\StructType\\PcmCreateTripInsightMessageResponse',
            'CreateTripInsightMsgResponse' => '\\Pcm\\StructType\\PcmCreateTripInsightMsgResponse',
            'CreateTripInsightMsgResponseBody' => '\\Pcm\\StructType\\PcmCreateTripInsightMsgResponseBody',
            'GenerateDriveTimePolygon' => '\\Pcm\\StructType\\PcmGenerateDriveTimePolygon',
            'DriveTimePolygonRequest' => '\\Pcm\\StructType\\PcmDriveTimePolygonRequest',
            'DriveTimePolygonRequestBody' => '\\Pcm\\StructType\\PcmDriveTimePolygonRequestBody',
            'GenerateDriveTimePolygonResponse' => '\\Pcm\\StructType\\PcmGenerateDriveTimePolygonResponse',
            'DriveTimePolygonResponse' => '\\Pcm\\StructType\\PcmDriveTimePolygonResponse',
            'DriveTimePolygonResponseBody' => '\\Pcm\\StructType\\PcmDriveTimePolygonResponseBody',
            'GetPoisAlongRoute' => '\\Pcm\\StructType\\PcmGetPoisAlongRoute',
            'PoisAlongRouteRequest' => '\\Pcm\\StructType\\PcmPoisAlongRouteRequest',
            'PoisAlongRouteRequestBody' => '\\Pcm\\StructType\\PcmPoisAlongRouteRequestBody',
            'ArrayOfPOIGenericType' => '\\Pcm\\ArrayType\\PcmArrayOfPOIGenericType',
            'ArrayOfPOIHosType' => '\\Pcm\\ArrayType\\PcmArrayOfPOIHosType',
            'GetPoisAlongRouteResponse' => '\\Pcm\\StructType\\PcmGetPoisAlongRouteResponse',
            'PoisAlongRouteResponse' => '\\Pcm\\StructType\\PcmPoisAlongRouteResponse',
            'PoisAlongRouteResponseBody' => '\\Pcm\\StructType\\PcmPoisAlongRouteResponseBody',
            'ArrayOfPOIAlongRouteMatch' => '\\Pcm\\ArrayType\\PcmArrayOfPOIAlongRouteMatch',
            'POIAlongRouteMatch' => '\\Pcm\\StructType\\PcmPOIAlongRouteMatch',
            'ProcessMap' => '\\Pcm\\StructType\\PcmProcessMap',
            'MapRoutesRequest' => '\\Pcm\\StructType\\PcmMapRoutesRequest',
            'MapRoutesRequestBody' => '\\Pcm\\StructType\\PcmMapRoutesRequestBody',
            'MapRequestBody' => '\\Pcm\\StructType\\PcmMapRequestBody',
            'MapViewport' => '\\Pcm\\StructType\\PcmMapViewport',
            'Point' => '\\Pcm\\StructType\\PcmPoint',
            'ArrayOfDrawerType' => '\\Pcm\\ArrayType\\PcmArrayOfDrawerType',
            'ArrayOfLegend' => '\\Pcm\\ArrayType\\PcmArrayOfLegend',
            'Legend' => '\\Pcm\\StructType\\PcmLegend',
            'ArrayOfGeometry' => '\\Pcm\\ArrayType\\PcmArrayOfGeometry',
            'Geometry' => '\\Pcm\\StructType\\PcmGeometry',
            'RGB' => '\\Pcm\\StructType\\PcmRGB',
            'ShapeGeometry' => '\\Pcm\\StructType\\PcmShapeGeometry',
            'RegionGeometry' => '\\Pcm\\StructType\\PcmRegionGeometry',
            'PinDrawer' => '\\Pcm\\StructType\\PcmPinDrawer',
            'ArrayOfPin' => '\\Pcm\\ArrayType\\PcmArrayOfPin',
            'Pin' => '\\Pcm\\StructType\\PcmPin',
            'ArrayOfPinCategory' => '\\Pcm\\ArrayType\\PcmArrayOfPinCategory',
            'PinCategory' => '\\Pcm\\StructType\\PcmPinCategory',
            'ALKStyle' => '\\Pcm\\StructType\\PcmALKStyle',
            'ALKFont' => '\\Pcm\\StructType\\PcmALKFont',
            'ALKPen' => '\\Pcm\\StructType\\PcmALKPen',
            'ALKBrush' => '\\Pcm\\StructType\\PcmALKBrush',
            'ALKShadow' => '\\Pcm\\StructType\\PcmALKShadow',
            'TrafficDrawer' => '\\Pcm\\StructType\\PcmTrafficDrawer',
            'ArrayOfMapRoute' => '\\Pcm\\ArrayType\\PcmArrayOfMapRoute',
            'MapRoute' => '\\Pcm\\StructType\\PcmMapRoute',
            'RouteLegOptions' => '\\Pcm\\StructType\\PcmRouteLegOptions',
            'ArrayOfRouteLineOptions' => '\\Pcm\\ArrayType\\PcmArrayOfRouteLineOptions',
            'RouteLineOptions' => '\\Pcm\\StructType\\PcmRouteLineOptions',
            'ArrayOfRouteLabelOptions' => '\\Pcm\\ArrayType\\PcmArrayOfRouteLabelOptions',
            'RouteLabelOptions' => '\\Pcm\\StructType\\PcmRouteLabelOptions',
            'ProcessMapResponse' => '\\Pcm\\StructType\\PcmProcessMapResponse',
            'MapRoutesResponse' => '\\Pcm\\StructType\\PcmMapRoutesResponse',
            'MapRoutesResponseBody' => '\\Pcm\\StructType\\PcmMapRoutesResponseBody',
            'RenderedMap' => '\\Pcm\\StructType\\PcmRenderedMap',
            'ArrayOfMapGroupInfo' => '\\Pcm\\ArrayType\\PcmArrayOfMapGroupInfo',
            'MapGroupInfo' => '\\Pcm\\StructType\\PcmMapGroupInfo',
            'ArrayOfLayer' => '\\Pcm\\ArrayType\\PcmArrayOfLayer',
            'Layer' => '\\Pcm\\StructType\\PcmLayer',
            'ArrayOfMapPointInfo' => '\\Pcm\\ArrayType\\PcmArrayOfMapPointInfo',
            'MapPointInfo' => '\\Pcm\\StructType\\PcmMapPointInfo',
            'ImportAvoidFavorSet' => '\\Pcm\\StructType\\PcmImportAvoidFavorSet',
            'ImportAFSetRequest' => '\\Pcm\\StructType\\PcmImportAFSetRequest',
            'ImportAFSetRequestBody' => '\\Pcm\\StructType\\PcmImportAFSetRequestBody',
            'CustomDataSetRequestBody' => '\\Pcm\\StructType\\PcmCustomDataSetRequestBody',
            'AddCustomDataSetRequestBody' => '\\Pcm\\StructType\\PcmAddCustomDataSetRequestBody',
            'AddGeofenceSetRequestBody' => '\\Pcm\\StructType\\PcmAddGeofenceSetRequestBody',
            'AddGeofenceSet' => '\\Pcm\\StructType\\PcmAddGeofenceSet',
            'GeofenceSet' => '\\Pcm\\StructType\\PcmGeofenceSet',
            'ArrayOfGeofence' => '\\Pcm\\ArrayType\\PcmArrayOfGeofence',
            'Geofence' => '\\Pcm\\StructType\\PcmGeofence',
            'AddGeofence' => '\\Pcm\\StructType\\PcmAddGeofence',
            'UpdateGeofenceSetRequestBody' => '\\Pcm\\StructType\\PcmUpdateGeofenceSetRequestBody',
            'GetCustomPlaceSetRequestBody' => '\\Pcm\\StructType\\PcmGetCustomPlaceSetRequestBody',
            'GetAvoidFavorSetRequestBody' => '\\Pcm\\StructType\\PcmGetAvoidFavorSetRequestBody',
            'GeofenceIntersectRequestBody' => '\\Pcm\\StructType\\PcmGeofenceIntersectRequestBody',
            'ImportAvoidFavorSetResponse' => '\\Pcm\\StructType\\PcmImportAvoidFavorSetResponse',
            'ImportAFSetResponse' => '\\Pcm\\StructType\\PcmImportAFSetResponse',
            'ImportAFSetResponseBody' => '\\Pcm\\StructType\\PcmImportAFSetResponseBody',
            'GetAvoidFavorSets' => '\\Pcm\\StructType\\PcmGetAvoidFavorSets',
            'GetAvoidFavorSetRequest' => '\\Pcm\\StructType\\PcmGetAvoidFavorSetRequest',
            'GetAvoidFavorSetsResponse' => '\\Pcm\\StructType\\PcmGetAvoidFavorSetsResponse',
            'AFSetResponse' => '\\Pcm\\StructType\\PcmAFSetResponse',
            'AFSetResponseBody' => '\\Pcm\\StructType\\PcmAFSetResponseBody',
            'ArrayOfAFSet' => '\\Pcm\\ArrayType\\PcmArrayOfAFSet',
            'AFSet' => '\\Pcm\\StructType\\PcmAFSet',
            'ArrayOfAFLink' => '\\Pcm\\ArrayType\\PcmArrayOfAFLink',
            'AFLink' => '\\Pcm\\StructType\\PcmAFLink',
            'GetWeatherAlerts' => '\\Pcm\\StructType\\PcmGetWeatherAlerts',
            'WeatherAlertsPointsRequest' => '\\Pcm\\StructType\\PcmWeatherAlertsPointsRequest',
            'WeatherAlertsPointsRequestBody' => '\\Pcm\\StructType\\PcmWeatherAlertsPointsRequestBody',
            'WeatherAlertsBaseRequestBody' => '\\Pcm\\StructType\\PcmWeatherAlertsBaseRequestBody',
            'GetWeatherAlertsResponse' => '\\Pcm\\StructType\\PcmGetWeatherAlertsResponse',
            'WeatherAlertsPointsResponse' => '\\Pcm\\StructType\\PcmWeatherAlertsPointsResponse',
            'WeatherAlertsPointsReponseBody' => '\\Pcm\\StructType\\PcmWeatherAlertsPointsReponseBody',
            'ArrayOfArrayOfWeatherAlertEvent' => '\\Pcm\\ArrayType\\PcmArrayOfArrayOfWeatherAlertEvent',
            'GetRouteMatrix' => '\\Pcm\\StructType\\PcmGetRouteMatrix',
            'RouteMatrixRequest' => '\\Pcm\\StructType\\PcmRouteMatrixRequest',
            'RouteMatrixRequestBody' => '\\Pcm\\StructType\\PcmRouteMatrixRequestBody',
            'GetRouteMatrixResponse' => '\\Pcm\\StructType\\PcmGetRouteMatrixResponse',
            'RouteMatrixResponse' => '\\Pcm\\StructType\\PcmRouteMatrixResponse',
            'RouteMatrixResponseBody' => '\\Pcm\\StructType\\PcmRouteMatrixResponseBody',
            'ArrayOfArrayOfRouteMatrixInfo' => '\\Pcm\\ArrayType\\PcmArrayOfArrayOfRouteMatrixInfo',
            'ArrayOfRouteMatrixInfo' => '\\Pcm\\ArrayType\\PcmArrayOfRouteMatrixInfo',
            'RouteMatrixInfo' => '\\Pcm\\StructType\\PcmRouteMatrixInfo',
            'AuthHeader' => '\\Pcm\\StructType\\PcmAuthHeader',
        );
    }
}
