<?php

namespace Pcm\EnumType;

/**
 * This class stands for VolumeUnits EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:VolumeUnits
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmVolumeUnits
{
    /**
     * Constant for value 'Gallons'
     * @return string 'Gallons'
     */
    const VALUE_GALLONS = 'Gallons';
    /**
     * Constant for value 'Liters'
     * @return string 'Liters'
     */
    const VALUE_LITERS = 'Liters';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GALLONS
     * @uses self::VALUE_LITERS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GALLONS,
            self::VALUE_LITERS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
