<?php

namespace Pcm\EnumType;

/**
 * This class stands for VehicleType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:VehicleType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmVehicleType
{
    /**
     * Constant for value 'Truck'
     * @return string 'Truck'
     */
    const VALUE_TRUCK = 'Truck';
    /**
     * Constant for value 'LightTruck'
     * @return string 'LightTruck'
     */
    const VALUE_LIGHT_TRUCK = 'LightTruck';
    /**
     * Constant for value 'Auto'
     * @return string 'Auto'
     */
    const VALUE_AUTO = 'Auto';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRUCK
     * @uses self::VALUE_LIGHT_TRUCK
     * @uses self::VALUE_AUTO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRUCK,
            self::VALUE_LIGHT_TRUCK,
            self::VALUE_AUTO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
