<?php

namespace Pcm\EnumType;

/**
 * This class stands for ShapeType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ShapeType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmShapeType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Line'
     * @return string 'Line'
     */
    const VALUE_LINE = 'Line';
    /**
     * Constant for value 'Circle'
     * @return string 'Circle'
     */
    const VALUE_CIRCLE = 'Circle';
    /**
     * Constant for value 'Rect'
     * @return string 'Rect'
     */
    const VALUE_RECT = 'Rect';
    /**
     * Constant for value 'Ellipse'
     * @return string 'Ellipse'
     */
    const VALUE_ELLIPSE = 'Ellipse';
    /**
     * Constant for value 'Polygon'
     * @return string 'Polygon'
     */
    const VALUE_POLYGON = 'Polygon';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_LINE
     * @uses self::VALUE_CIRCLE
     * @uses self::VALUE_RECT
     * @uses self::VALUE_ELLIPSE
     * @uses self::VALUE_POLYGON
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_LINE,
            self::VALUE_CIRCLE,
            self::VALUE_RECT,
            self::VALUE_ELLIPSE,
            self::VALUE_POLYGON,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
