<?php

namespace Pcm\EnumType;

/**
 * This class stands for ProjectionType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProjectionType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmProjectionType
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'FixedLat'
     * @return string 'FixedLat'
     */
    const VALUE_FIXED_LAT = 'FixedLat';
    /**
     * Constant for value 'Mercator'
     * @return string 'Mercator'
     */
    const VALUE_MERCATOR = 'Mercator';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_FIXED_LAT
     * @uses self::VALUE_MERCATOR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_FIXED_LAT,
            self::VALUE_MERCATOR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
