<?php

namespace Pcm\EnumType;

/**
 * This class stands for PoiSearchWindowUnits EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PoiSearchWindowUnits
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmPoiSearchWindowUnits
{
    /**
     * Constant for value 'Miles'
     * @return string 'Miles'
     */
    const VALUE_MILES = 'Miles';
    /**
     * Constant for value 'Minutes'
     * @return string 'Minutes'
     */
    const VALUE_MINUTES = 'Minutes';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MILES
     * @uses self::VALUE_MINUTES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MILES,
            self::VALUE_MINUTES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
