<?php

namespace Pcm\EnumType;

/**
 * This class stands for PinType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PinType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmPinType
{
    /**
     * Constant for value 'PDW_BMP'
     * @return string 'PDW_BMP'
     */
    const VALUE_PDW_BMP = 'PDW_BMP';
    /**
     * Constant for value 'PDW_CIRCLE'
     * @return string 'PDW_CIRCLE'
     */
    const VALUE_PDW_CIRCLE = 'PDW_CIRCLE';
    /**
     * Constant for value 'PDW_SQUARE'
     * @return string 'PDW_SQUARE'
     */
    const VALUE_PDW_SQUARE = 'PDW_SQUARE';
    /**
     * Constant for value 'PDW_DIAMOND'
     * @return string 'PDW_DIAMOND'
     */
    const VALUE_PDW_DIAMOND = 'PDW_DIAMOND';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PDW_BMP
     * @uses self::VALUE_PDW_CIRCLE
     * @uses self::VALUE_PDW_SQUARE
     * @uses self::VALUE_PDW_DIAMOND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PDW_BMP,
            self::VALUE_PDW_CIRCLE,
            self::VALUE_PDW_SQUARE,
            self::VALUE_PDW_DIAMOND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
