<?php

namespace Pcm\EnumType;

/**
 * This class stands for POIHosType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:POIHosType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmPOIHosType
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'TruckServiceHoS'
     * @return string 'TruckServiceHoS'
     */
    const VALUE_TRUCK_SERVICE_HO_S = 'TruckServiceHoS';
    /**
     * Constant for value 'RestAreaHoS'
     * @return string 'RestAreaHoS'
     */
    const VALUE_REST_AREA_HO_S = 'RestAreaHoS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_TRUCK_SERVICE_HO_S
     * @uses self::VALUE_REST_AREA_HO_S
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_TRUCK_SERVICE_HO_S,
            self::VALUE_REST_AREA_HO_S,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
