<?php

namespace Pcm\EnumType;

/**
 * This class stands for MapImageOption EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MapImageOption
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmMapImageOption
{
    /**
     * Constant for value 'Both'
     * @return string 'Both'
     */
    const VALUE_BOTH = 'Both';
    /**
     * Constant for value 'Background'
     * @return string 'Background'
     */
    const VALUE_BACKGROUND = 'Background';
    /**
     * Constant for value 'Foreground'
     * @return string 'Foreground'
     */
    const VALUE_FOREGROUND = 'Foreground';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BOTH
     * @uses self::VALUE_BACKGROUND
     * @uses self::VALUE_FOREGROUND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BOTH,
            self::VALUE_BACKGROUND,
            self::VALUE_FOREGROUND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
