<?php

namespace Pcm\EnumType;

/**
 * This class stands for GeocodeCitySearchFilter EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GeocodeCitySearchFilter
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmGeocodeCitySearchFilter
{
    /**
     * Constant for value 'CitiesWithZips'
     * @return string 'CitiesWithZips'
     */
    const VALUE_CITIES_WITH_ZIPS = 'CitiesWithZips';
    /**
     * Constant for value 'CityCentersOnly'
     * @return string 'CityCentersOnly'
     */
    const VALUE_CITY_CENTERS_ONLY = 'CityCentersOnly';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CITIES_WITH_ZIPS
     * @uses self::VALUE_CITY_CENTERS_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CITIES_WITH_ZIPS,
            self::VALUE_CITY_CENTERS_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
