<?php

namespace Pcm\EnumType;

/**
 * This class stands for AmPmType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AmPmType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmAmPmType
{
    /**
     * Constant for value 'Military'
     * @return string 'Military'
     */
    const VALUE_MILITARY = 'Military';
    /**
     * Constant for value 'AM'
     * @return string 'AM'
     */
    const VALUE_AM = 'AM';
    /**
     * Constant for value 'PM'
     * @return string 'PM'
     */
    const VALUE_PM = 'PM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MILITARY
     * @uses self::VALUE_AM
     * @uses self::VALUE_PM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MILITARY,
            self::VALUE_AM,
            self::VALUE_PM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
