<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStateReport ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfStateReport
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfStateReport extends AbstractStructArrayBase
{
    /**
     * The StateReport
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmStateReport[]
     */
    public $StateReport;
    /**
     * Constructor method for ArrayOfStateReport
     * @uses PcmArrayOfStateReport::setStateReport()
     * @param \Pcm\StructType\PcmStateReport[] $stateReport
     */
    public function __construct(array $stateReport = array())
    {
        $this
            ->setStateReport($stateReport);
    }
    /**
     * Get StateReport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmStateReport[]|null
     */
    public function getStateReport()
    {
        return isset($this->StateReport) ? $this->StateReport : null;
    }
    /**
     * Set StateReport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmStateReport[] $stateReport
     * @return \Pcm\ArrayType\PcmArrayOfStateReport
     */
    public function setStateReport(array $stateReport = array())
    {
        foreach ($stateReport as $arrayOfStateReportStateReportItem) {
            // validation for constraint: itemType
            if (!$arrayOfStateReportStateReportItem instanceof \Pcm\StructType\PcmStateReport) {
                throw new \InvalidArgumentException(sprintf('The StateReport property can only contain items of \Pcm\StructType\PcmStateReport, "%s" given', is_object($arrayOfStateReportStateReportItem) ? get_class($arrayOfStateReportStateReportItem) : gettype($arrayOfStateReportStateReportItem)), __LINE__);
            }
        }
        if (is_null($stateReport) || (is_array($stateReport) && empty($stateReport))) {
            unset($this->StateReport);
        } else {
            $this->StateReport = $stateReport;
        }
        return $this;
    }
    /**
     * Add item to StateReport value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmStateReport $item
     * @return \Pcm\ArrayType\PcmArrayOfStateReport
     */
    public function addToStateReport(\Pcm\StructType\PcmStateReport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmStateReport) {
            throw new \InvalidArgumentException(sprintf('The StateReport property can only contain items of \Pcm\StructType\PcmStateReport, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StateReport[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmStateReport|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmStateReport|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmStateReport|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmStateReport|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmStateReport|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StateReport
     */
    public function getAttributeName()
    {
        return 'StateReport';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfStateReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
