<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoadSpeed ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRoadSpeed
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfRoadSpeed extends AbstractStructArrayBase
{
    /**
     * The RoadSpeed
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRoadSpeed[]
     */
    public $RoadSpeed;
    /**
     * Constructor method for ArrayOfRoadSpeed
     * @uses PcmArrayOfRoadSpeed::setRoadSpeed()
     * @param \Pcm\StructType\PcmRoadSpeed[] $roadSpeed
     */
    public function __construct(array $roadSpeed = array())
    {
        $this
            ->setRoadSpeed($roadSpeed);
    }
    /**
     * Get RoadSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRoadSpeed[]|null
     */
    public function getRoadSpeed()
    {
        return isset($this->RoadSpeed) ? $this->RoadSpeed : null;
    }
    /**
     * Set RoadSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmRoadSpeed[] $roadSpeed
     * @return \Pcm\ArrayType\PcmArrayOfRoadSpeed
     */
    public function setRoadSpeed(array $roadSpeed = array())
    {
        foreach ($roadSpeed as $arrayOfRoadSpeedRoadSpeedItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoadSpeedRoadSpeedItem instanceof \Pcm\StructType\PcmRoadSpeed) {
                throw new \InvalidArgumentException(sprintf('The RoadSpeed property can only contain items of \Pcm\StructType\PcmRoadSpeed, "%s" given', is_object($arrayOfRoadSpeedRoadSpeedItem) ? get_class($arrayOfRoadSpeedRoadSpeedItem) : gettype($arrayOfRoadSpeedRoadSpeedItem)), __LINE__);
            }
        }
        if (is_null($roadSpeed) || (is_array($roadSpeed) && empty($roadSpeed))) {
            unset($this->RoadSpeed);
        } else {
            $this->RoadSpeed = $roadSpeed;
        }
        return $this;
    }
    /**
     * Add item to RoadSpeed value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmRoadSpeed $item
     * @return \Pcm\ArrayType\PcmArrayOfRoadSpeed
     */
    public function addToRoadSpeed(\Pcm\StructType\PcmRoadSpeed $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmRoadSpeed) {
            throw new \InvalidArgumentException(sprintf('The RoadSpeed property can only contain items of \Pcm\StructType\PcmRoadSpeed, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoadSpeed[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmRoadSpeed|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmRoadSpeed|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmRoadSpeed|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmRoadSpeed|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmRoadSpeed|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoadSpeed
     */
    public function getAttributeName()
    {
        return 'RoadSpeed';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfRoadSpeed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
