<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPin ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPin
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfPin extends AbstractStructArrayBase
{
    /**
     * The Pin
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmPin[]
     */
    public $Pin;
    /**
     * Constructor method for ArrayOfPin
     * @uses PcmArrayOfPin::setPin()
     * @param \Pcm\StructType\PcmPin[] $pin
     */
    public function __construct(array $pin = array())
    {
        $this
            ->setPin($pin);
    }
    /**
     * Get Pin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmPin[]|null
     */
    public function getPin()
    {
        return isset($this->Pin) ? $this->Pin : null;
    }
    /**
     * Set Pin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmPin[] $pin
     * @return \Pcm\ArrayType\PcmArrayOfPin
     */
    public function setPin(array $pin = array())
    {
        foreach ($pin as $arrayOfPinPinItem) {
            // validation for constraint: itemType
            if (!$arrayOfPinPinItem instanceof \Pcm\StructType\PcmPin) {
                throw new \InvalidArgumentException(sprintf('The Pin property can only contain items of \Pcm\StructType\PcmPin, "%s" given', is_object($arrayOfPinPinItem) ? get_class($arrayOfPinPinItem) : gettype($arrayOfPinPinItem)), __LINE__);
            }
        }
        if (is_null($pin) || (is_array($pin) && empty($pin))) {
            unset($this->Pin);
        } else {
            $this->Pin = $pin;
        }
        return $this;
    }
    /**
     * Add item to Pin value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmPin $item
     * @return \Pcm\ArrayType\PcmArrayOfPin
     */
    public function addToPin(\Pcm\StructType\PcmPin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmPin) {
            throw new \InvalidArgumentException(sprintf('The Pin property can only contain items of \Pcm\StructType\PcmPin, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Pin[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmPin|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmPin|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmPin|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmPin|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmPin|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Pin
     */
    public function getAttributeName()
    {
        return 'Pin';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfPin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
