<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDetailReport ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDetailReport
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfDetailReport extends AbstractStructArrayBase
{
    /**
     * The DetailReport
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmDetailReport[]
     */
    public $DetailReport;
    /**
     * Constructor method for ArrayOfDetailReport
     * @uses PcmArrayOfDetailReport::setDetailReport()
     * @param \Pcm\StructType\PcmDetailReport[] $detailReport
     */
    public function __construct(array $detailReport = array())
    {
        $this
            ->setDetailReport($detailReport);
    }
    /**
     * Get DetailReport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmDetailReport[]|null
     */
    public function getDetailReport()
    {
        return isset($this->DetailReport) ? $this->DetailReport : null;
    }
    /**
     * Set DetailReport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmDetailReport[] $detailReport
     * @return \Pcm\ArrayType\PcmArrayOfDetailReport
     */
    public function setDetailReport(array $detailReport = array())
    {
        foreach ($detailReport as $arrayOfDetailReportDetailReportItem) {
            // validation for constraint: itemType
            if (!$arrayOfDetailReportDetailReportItem instanceof \Pcm\StructType\PcmDetailReport) {
                throw new \InvalidArgumentException(sprintf('The DetailReport property can only contain items of \Pcm\StructType\PcmDetailReport, "%s" given', is_object($arrayOfDetailReportDetailReportItem) ? get_class($arrayOfDetailReportDetailReportItem) : gettype($arrayOfDetailReportDetailReportItem)), __LINE__);
            }
        }
        if (is_null($detailReport) || (is_array($detailReport) && empty($detailReport))) {
            unset($this->DetailReport);
        } else {
            $this->DetailReport = $detailReport;
        }
        return $this;
    }
    /**
     * Add item to DetailReport value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmDetailReport $item
     * @return \Pcm\ArrayType\PcmArrayOfDetailReport
     */
    public function addToDetailReport(\Pcm\StructType\PcmDetailReport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmDetailReport) {
            throw new \InvalidArgumentException(sprintf('The DetailReport property can only contain items of \Pcm\StructType\PcmDetailReport, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DetailReport[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmDetailReport|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmDetailReport|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmDetailReport|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmDetailReport|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmDetailReport|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DetailReport
     */
    public function getAttributeName()
    {
        return 'DetailReport';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfDetailReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
