<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrafficDrawer StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TrafficDrawer
 * @package Pcm
 * @subpackage Structs
 */
class PcmTrafficDrawer extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The TimeType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TimeType;
    /**
     * The DateAndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmDateTimeType
     */
    public $DateAndTime;
    /**
     * Constructor method for TrafficDrawer
     * @uses PcmTrafficDrawer::setType()
     * @uses PcmTrafficDrawer::setTimeType()
     * @uses PcmTrafficDrawer::setDateAndTime()
     * @param string $type
     * @param string $timeType
     * @param \Pcm\StructType\PcmDateTimeType $dateAndTime
     */
    public function __construct($type = null, $timeType = null, \Pcm\StructType\PcmDateTimeType $dateAndTime = null)
    {
        $this
            ->setType($type)
            ->setTimeType($timeType)
            ->setDateAndTime($dateAndTime);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Pcm\EnumType\PcmTrafficType::valueIsValid()
     * @uses \Pcm\EnumType\PcmTrafficType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Pcm\StructType\PcmTrafficDrawer
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmTrafficType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \Pcm\EnumType\PcmTrafficType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TimeType value
     * @return string|null
     */
    public function getTimeType()
    {
        return $this->TimeType;
    }
    /**
     * Set TimeType value
     * @uses \Pcm\EnumType\PcmTrafficTime::valueIsValid()
     * @uses \Pcm\EnumType\PcmTrafficTime::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeType
     * @return \Pcm\StructType\PcmTrafficDrawer
     */
    public function setTimeType($timeType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmTrafficTime::valueIsValid($timeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeType, implode(', ', \Pcm\EnumType\PcmTrafficTime::getValidValues())), __LINE__);
        }
        $this->TimeType = $timeType;
        return $this;
    }
    /**
     * Get DateAndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmDateTimeType|null
     */
    public function getDateAndTime()
    {
        return isset($this->DateAndTime) ? $this->DateAndTime : null;
    }
    /**
     * Set DateAndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmDateTimeType $dateAndTime
     * @return \Pcm\StructType\PcmTrafficDrawer
     */
    public function setDateAndTime(\Pcm\StructType\PcmDateTimeType $dateAndTime = null)
    {
        if (is_null($dateAndTime) || (is_array($dateAndTime) && empty($dateAndTime))) {
            unset($this->DateAndTime);
        } else {
            $this->DateAndTime = $dateAndTime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmTrafficDrawer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
