<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomDataSetRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomDataSetRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmCustomDataSetRequestBody extends PcmAddCustomDataSetRequestBody
{
    /**
     * The IncludeContents
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeContents;
    /**
     * The SetID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SetID;
    /**
     * Constructor method for CustomDataSetRequestBody
     * @uses PcmCustomDataSetRequestBody::setIncludeContents()
     * @uses PcmCustomDataSetRequestBody::setSetID()
     * @param bool $includeContents
     * @param int $setID
     */
    public function __construct($includeContents = null, $setID = null)
    {
        $this
            ->setIncludeContents($includeContents)
            ->setSetID($setID);
    }
    /**
     * Get IncludeContents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeContents()
    {
        return isset($this->IncludeContents) ? $this->IncludeContents : null;
    }
    /**
     * Set IncludeContents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeContents
     * @return \Pcm\StructType\PcmCustomDataSetRequestBody
     */
    public function setIncludeContents($includeContents = null)
    {
        if (is_null($includeContents) || (is_array($includeContents) && empty($includeContents))) {
            unset($this->IncludeContents);
        } else {
            $this->IncludeContents = $includeContents;
        }
        return $this;
    }
    /**
     * Get SetID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSetID()
    {
        return isset($this->SetID) ? $this->SetID : null;
    }
    /**
     * Set SetID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $setID
     * @return \Pcm\StructType\PcmCustomDataSetRequestBody
     */
    public function setSetID($setID = null)
    {
        // validation for constraint: int
        if (!is_null($setID) && !is_numeric($setID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($setID)), __LINE__);
        }
        if (is_null($setID) || (is_array($setID) && empty($setID))) {
            unset($this->SetID);
        } else {
            $this->SetID = $setID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmCustomDataSetRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
