<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Coordinates StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Coordinates
 * @package Pcm
 * @subpackage Structs
 */
class PcmCoordinates extends AbstractStructBase
{
    /**
     * The Lat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Lat;
    /**
     * The Lon
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Lon;
    /**
     * Constructor method for Coordinates
     * @uses PcmCoordinates::setLat()
     * @uses PcmCoordinates::setLon()
     * @param string $lat
     * @param string $lon
     */
    public function __construct($lat = null, $lon = null)
    {
        $this
            ->setLat($lat)
            ->setLon($lon);
    }
    /**
     * Get Lat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLat()
    {
        return isset($this->Lat) ? $this->Lat : null;
    }
    /**
     * Set Lat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lat
     * @return \Pcm\StructType\PcmCoordinates
     */
    public function setLat($lat = null)
    {
        // validation for constraint: string
        if (!is_null($lat) && !is_string($lat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lat)), __LINE__);
        }
        if (is_null($lat) || (is_array($lat) && empty($lat))) {
            unset($this->Lat);
        } else {
            $this->Lat = $lat;
        }
        return $this;
    }
    /**
     * Get Lon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLon()
    {
        return isset($this->Lon) ? $this->Lon : null;
    }
    /**
     * Set Lon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lon
     * @return \Pcm\StructType\PcmCoordinates
     */
    public function setLon($lon = null)
    {
        // validation for constraint: string
        if (!is_null($lon) && !is_string($lon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lon)), __LINE__);
        }
        if (is_null($lon) || (is_array($lon) && empty($lon))) {
            unset($this->Lon);
        } else {
            $this->Lon = $lon;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmCoordinates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
