<?php

namespace Pcm\EnumType;

/**
 * This class stands for SideOfStreetAdherenceLevel EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SideOfStreetAdherenceLevel
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmSideOfStreetAdherenceLevel
{
    /**
     * Constant for value 'Off'
     * @return string 'Off'
     */
    const VALUE_OFF = 'Off';
    /**
     * Constant for value 'Minimal'
     * @return string 'Minimal'
     */
    const VALUE_MINIMAL = 'Minimal';
    /**
     * Constant for value 'Moderate'
     * @return string 'Moderate'
     */
    const VALUE_MODERATE = 'Moderate';
    /**
     * Constant for value 'Average'
     * @return string 'Average'
     */
    const VALUE_AVERAGE = 'Average';
    /**
     * Constant for value 'Strict'
     * @return string 'Strict'
     */
    const VALUE_STRICT = 'Strict';
    /**
     * Constant for value 'Adhere'
     * @return string 'Adhere'
     */
    const VALUE_ADHERE = 'Adhere';
    /**
     * Constant for value 'StronglyAdhere'
     * @return string 'StronglyAdhere'
     */
    const VALUE_STRONGLY_ADHERE = 'StronglyAdhere';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OFF
     * @uses self::VALUE_MINIMAL
     * @uses self::VALUE_MODERATE
     * @uses self::VALUE_AVERAGE
     * @uses self::VALUE_STRICT
     * @uses self::VALUE_ADHERE
     * @uses self::VALUE_STRONGLY_ADHERE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OFF,
            self::VALUE_MINIMAL,
            self::VALUE_MODERATE,
            self::VALUE_AVERAGE,
            self::VALUE_STRICT,
            self::VALUE_ADHERE,
            self::VALUE_STRONGLY_ADHERE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
