<?php

namespace Pcm\EnumType;

/**
 * This class stands for MapLayering EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MapLayering
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmMapLayering
{
    /**
     * Constant for value 'MapAndPointsOneLayer'
     * @return string 'MapAndPointsOneLayer'
     */
    const VALUE_MAP_AND_POINTS_ONE_LAYER = 'MapAndPointsOneLayer';
    /**
     * Constant for value 'MapLayer'
     * @return string 'MapLayer'
     */
    const VALUE_MAP_LAYER = 'MapLayer';
    /**
     * Constant for value 'PointsLayer'
     * @return string 'PointsLayer'
     */
    const VALUE_POINTS_LAYER = 'PointsLayer';
    /**
     * Constant for value 'MapAndPointsTwoLayers'
     * @return string 'MapAndPointsTwoLayers'
     */
    const VALUE_MAP_AND_POINTS_TWO_LAYERS = 'MapAndPointsTwoLayers';
    /**
     * Constant for value 'BackgroundOnly'
     * @return string 'BackgroundOnly'
     */
    const VALUE_BACKGROUND_ONLY = 'BackgroundOnly';
    /**
     * Constant for value 'NoBackground'
     * @return string 'NoBackground'
     */
    const VALUE_NO_BACKGROUND = 'NoBackground';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MAP_AND_POINTS_ONE_LAYER
     * @uses self::VALUE_MAP_LAYER
     * @uses self::VALUE_POINTS_LAYER
     * @uses self::VALUE_MAP_AND_POINTS_TWO_LAYERS
     * @uses self::VALUE_BACKGROUND_ONLY
     * @uses self::VALUE_NO_BACKGROUND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MAP_AND_POINTS_ONE_LAYER,
            self::VALUE_MAP_LAYER,
            self::VALUE_POINTS_LAYER,
            self::VALUE_MAP_AND_POINTS_TWO_LAYERS,
            self::VALUE_BACKGROUND_ONLY,
            self::VALUE_NO_BACKGROUND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
