<?php

namespace Pcm\EnumType;

/**
 * This class stands for EngineEmissionType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EngineEmissionType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmEngineEmissionType
{
    /**
     * Constant for value 'EuroI'
     * @return string 'EuroI'
     */
    const VALUE_EURO_I = 'EuroI';
    /**
     * Constant for value 'EuroII'
     * @return string 'EuroII'
     */
    const VALUE_EURO_II = 'EuroII';
    /**
     * Constant for value 'EuroIII'
     * @return string 'EuroIII'
     */
    const VALUE_EURO_III = 'EuroIII';
    /**
     * Constant for value 'EuroIV'
     * @return string 'EuroIV'
     */
    const VALUE_EURO_IV = 'EuroIV';
    /**
     * Constant for value 'EuroV'
     * @return string 'EuroV'
     */
    const VALUE_EURO_V = 'EuroV';
    /**
     * Constant for value 'EuroVI'
     * @return string 'EuroVI'
     */
    const VALUE_EURO_VI = 'EuroVI';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EURO_I
     * @uses self::VALUE_EURO_II
     * @uses self::VALUE_EURO_III
     * @uses self::VALUE_EURO_IV
     * @uses self::VALUE_EURO_V
     * @uses self::VALUE_EURO_VI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EURO_I,
            self::VALUE_EURO_II,
            self::VALUE_EURO_III,
            self::VALUE_EURO_IV,
            self::VALUE_EURO_V,
            self::VALUE_EURO_VI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
