<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRouteLineOptions ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRouteLineOptions
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfRouteLineOptions extends AbstractStructArrayBase
{
    /**
     * The RouteLineOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRouteLineOptions[]
     */
    public $RouteLineOptions;
    /**
     * Constructor method for ArrayOfRouteLineOptions
     * @uses PcmArrayOfRouteLineOptions::setRouteLineOptions()
     * @param \Pcm\StructType\PcmRouteLineOptions[] $routeLineOptions
     */
    public function __construct(array $routeLineOptions = array())
    {
        $this
            ->setRouteLineOptions($routeLineOptions);
    }
    /**
     * Get RouteLineOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRouteLineOptions[]|null
     */
    public function getRouteLineOptions()
    {
        return isset($this->RouteLineOptions) ? $this->RouteLineOptions : null;
    }
    /**
     * Set RouteLineOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmRouteLineOptions[] $routeLineOptions
     * @return \Pcm\ArrayType\PcmArrayOfRouteLineOptions
     */
    public function setRouteLineOptions(array $routeLineOptions = array())
    {
        foreach ($routeLineOptions as $arrayOfRouteLineOptionsRouteLineOptionsItem) {
            // validation for constraint: itemType
            if (!$arrayOfRouteLineOptionsRouteLineOptionsItem instanceof \Pcm\StructType\PcmRouteLineOptions) {
                throw new \InvalidArgumentException(sprintf('The RouteLineOptions property can only contain items of \Pcm\StructType\PcmRouteLineOptions, "%s" given', is_object($arrayOfRouteLineOptionsRouteLineOptionsItem) ? get_class($arrayOfRouteLineOptionsRouteLineOptionsItem) : gettype($arrayOfRouteLineOptionsRouteLineOptionsItem)), __LINE__);
            }
        }
        if (is_null($routeLineOptions) || (is_array($routeLineOptions) && empty($routeLineOptions))) {
            unset($this->RouteLineOptions);
        } else {
            $this->RouteLineOptions = $routeLineOptions;
        }
        return $this;
    }
    /**
     * Add item to RouteLineOptions value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmRouteLineOptions $item
     * @return \Pcm\ArrayType\PcmArrayOfRouteLineOptions
     */
    public function addToRouteLineOptions(\Pcm\StructType\PcmRouteLineOptions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmRouteLineOptions) {
            throw new \InvalidArgumentException(sprintf('The RouteLineOptions property can only contain items of \Pcm\StructType\PcmRouteLineOptions, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RouteLineOptions[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmRouteLineOptions|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmRouteLineOptions|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmRouteLineOptions|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmRouteLineOptions|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmRouteLineOptions|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RouteLineOptions
     */
    public function getAttributeName()
    {
        return 'RouteLineOptions';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfRouteLineOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
