<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPinCategory ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPinCategory
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfPinCategory extends AbstractStructArrayBase
{
    /**
     * The PinCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmPinCategory[]
     */
    public $PinCategory;
    /**
     * Constructor method for ArrayOfPinCategory
     * @uses PcmArrayOfPinCategory::setPinCategory()
     * @param \Pcm\StructType\PcmPinCategory[] $pinCategory
     */
    public function __construct(array $pinCategory = array())
    {
        $this
            ->setPinCategory($pinCategory);
    }
    /**
     * Get PinCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmPinCategory[]|null
     */
    public function getPinCategory()
    {
        return isset($this->PinCategory) ? $this->PinCategory : null;
    }
    /**
     * Set PinCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmPinCategory[] $pinCategory
     * @return \Pcm\ArrayType\PcmArrayOfPinCategory
     */
    public function setPinCategory(array $pinCategory = array())
    {
        foreach ($pinCategory as $arrayOfPinCategoryPinCategoryItem) {
            // validation for constraint: itemType
            if (!$arrayOfPinCategoryPinCategoryItem instanceof \Pcm\StructType\PcmPinCategory) {
                throw new \InvalidArgumentException(sprintf('The PinCategory property can only contain items of \Pcm\StructType\PcmPinCategory, "%s" given', is_object($arrayOfPinCategoryPinCategoryItem) ? get_class($arrayOfPinCategoryPinCategoryItem) : gettype($arrayOfPinCategoryPinCategoryItem)), __LINE__);
            }
        }
        if (is_null($pinCategory) || (is_array($pinCategory) && empty($pinCategory))) {
            unset($this->PinCategory);
        } else {
            $this->PinCategory = $pinCategory;
        }
        return $this;
    }
    /**
     * Add item to PinCategory value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmPinCategory $item
     * @return \Pcm\ArrayType\PcmArrayOfPinCategory
     */
    public function addToPinCategory(\Pcm\StructType\PcmPinCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmPinCategory) {
            throw new \InvalidArgumentException(sprintf('The PinCategory property can only contain items of \Pcm\StructType\PcmPinCategory, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PinCategory[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmPinCategory|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmPinCategory|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmPinCategory|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmPinCategory|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmPinCategory|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PinCategory
     */
    public function getAttributeName()
    {
        return 'PinCategory';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfPinCategory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
