<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPOIGenericType ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPOIGenericType
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfPOIGenericType extends AbstractStructArrayBase
{
    /**
     * The POIGenericType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $POIGenericType;
    /**
     * Constructor method for ArrayOfPOIGenericType
     * @uses PcmArrayOfPOIGenericType::setPOIGenericType()
     * @param string[] $pOIGenericType
     */
    public function __construct(array $pOIGenericType = array())
    {
        $this
            ->setPOIGenericType($pOIGenericType);
    }
    /**
     * Get POIGenericType value
     * @return string[]|null
     */
    public function getPOIGenericType()
    {
        return $this->POIGenericType;
    }
    /**
     * Set POIGenericType value
     * @throws \InvalidArgumentException
     * @param string[] $pOIGenericType
     * @return \Pcm\ArrayType\PcmArrayOfPOIGenericType
     */
    public function setPOIGenericType(array $pOIGenericType = array())
    {
        $invalidValues = array();
        foreach ($pOIGenericType as $arrayOfPOIGenericTypePOIGenericTypeItem) {
            if (!\Pcm\EnumType\PcmPOIGenericType::valueIsValid($arrayOfPOIGenericTypePOIGenericTypeItem)) {
                $invalidValues[] = var_export($arrayOfPOIGenericTypePOIGenericTypeItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \Pcm\EnumType\PcmPOIGenericType::getValidValues())), __LINE__);
        }
        $this->POIGenericType = $pOIGenericType;
        return $this;
    }
    /**
     * Add item to POIGenericType value
     * @uses \Pcm\EnumType\PcmPOIGenericType::valueIsValid()
     * @uses \Pcm\EnumType\PcmPOIGenericType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Pcm\ArrayType\PcmArrayOfPOIGenericType
     */
    public function addToPOIGenericType($item)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmPOIGenericType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \Pcm\EnumType\PcmPOIGenericType::getValidValues())), __LINE__);
        }
        $this->POIGenericType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \Pcm\EnumType\PcmPOIGenericType::valueIsValid()
     * @param string $item
     * @return \Pcm\ArrayType\PcmArrayOfPOIGenericType
     */
    public function add($item)
    {
        if (!\Pcm\EnumType\PcmPOIGenericType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \Pcm\EnumType\PcmPOIGenericType::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string POIGenericType
     */
    public function getAttributeName()
    {
        return 'POIGenericType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfPOIGenericType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
