<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGeofence ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfGeofence
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfGeofence extends AbstractStructArrayBase
{
    /**
     * The Geofence
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmGeofence[]
     */
    public $Geofence;
    /**
     * Constructor method for ArrayOfGeofence
     * @uses PcmArrayOfGeofence::setGeofence()
     * @param \Pcm\StructType\PcmGeofence[] $geofence
     */
    public function __construct(array $geofence = array())
    {
        $this
            ->setGeofence($geofence);
    }
    /**
     * Get Geofence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmGeofence[]|null
     */
    public function getGeofence()
    {
        return isset($this->Geofence) ? $this->Geofence : null;
    }
    /**
     * Set Geofence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmGeofence[] $geofence
     * @return \Pcm\ArrayType\PcmArrayOfGeofence
     */
    public function setGeofence(array $geofence = array())
    {
        foreach ($geofence as $arrayOfGeofenceGeofenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfGeofenceGeofenceItem instanceof \Pcm\StructType\PcmGeofence) {
                throw new \InvalidArgumentException(sprintf('The Geofence property can only contain items of \Pcm\StructType\PcmGeofence, "%s" given', is_object($arrayOfGeofenceGeofenceItem) ? get_class($arrayOfGeofenceGeofenceItem) : gettype($arrayOfGeofenceGeofenceItem)), __LINE__);
            }
        }
        if (is_null($geofence) || (is_array($geofence) && empty($geofence))) {
            unset($this->Geofence);
        } else {
            $this->Geofence = $geofence;
        }
        return $this;
    }
    /**
     * Add item to Geofence value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmGeofence $item
     * @return \Pcm\ArrayType\PcmArrayOfGeofence
     */
    public function addToGeofence(\Pcm\StructType\PcmGeofence $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmGeofence) {
            throw new \InvalidArgumentException(sprintf('The Geofence property can only contain items of \Pcm\StructType\PcmGeofence, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Geofence[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmGeofence|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmGeofence|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmGeofence|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmGeofence|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmGeofence|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Geofence
     */
    public function getAttributeName()
    {
        return 'Geofence';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfGeofence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
