<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpeedLimitOptions StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SpeedLimitOptions
 * @package Pcm
 * @subpackage Structs
 */
class PcmSpeedLimitOptions extends AbstractStructBase
{
    /**
     * The Heading
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Heading;
    /**
     * The CurrentSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CurrentSpeed;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vehicle;
    /**
     * The Urban
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Urban;
    /**
     * The IncludeLinkInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeLinkInfo;
    /**
     * Constructor method for SpeedLimitOptions
     * @uses PcmSpeedLimitOptions::setHeading()
     * @uses PcmSpeedLimitOptions::setCurrentSpeed()
     * @uses PcmSpeedLimitOptions::setVehicle()
     * @uses PcmSpeedLimitOptions::setUrban()
     * @uses PcmSpeedLimitOptions::setIncludeLinkInfo()
     * @param float $heading
     * @param int $currentSpeed
     * @param string $vehicle
     * @param bool $urban
     * @param bool $includeLinkInfo
     */
    public function __construct($heading = null, $currentSpeed = null, $vehicle = null, $urban = null, $includeLinkInfo = null)
    {
        $this
            ->setHeading($heading)
            ->setCurrentSpeed($currentSpeed)
            ->setVehicle($vehicle)
            ->setUrban($urban)
            ->setIncludeLinkInfo($includeLinkInfo);
    }
    /**
     * Get Heading value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHeading()
    {
        return isset($this->Heading) ? $this->Heading : null;
    }
    /**
     * Set Heading value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $heading
     * @return \Pcm\StructType\PcmSpeedLimitOptions
     */
    public function setHeading($heading = null)
    {
        if (is_null($heading) || (is_array($heading) && empty($heading))) {
            unset($this->Heading);
        } else {
            $this->Heading = $heading;
        }
        return $this;
    }
    /**
     * Get CurrentSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCurrentSpeed()
    {
        return isset($this->CurrentSpeed) ? $this->CurrentSpeed : null;
    }
    /**
     * Set CurrentSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $currentSpeed
     * @return \Pcm\StructType\PcmSpeedLimitOptions
     */
    public function setCurrentSpeed($currentSpeed = null)
    {
        // validation for constraint: int
        if (!is_null($currentSpeed) && !is_numeric($currentSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentSpeed)), __LINE__);
        }
        if (is_null($currentSpeed) || (is_array($currentSpeed) && empty($currentSpeed))) {
            unset($this->CurrentSpeed);
        } else {
            $this->CurrentSpeed = $currentSpeed;
        }
        return $this;
    }
    /**
     * Get Vehicle value
     * @return string|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @uses \Pcm\EnumType\PcmVehicleType::valueIsValid()
     * @uses \Pcm\EnumType\PcmVehicleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicle
     * @return \Pcm\StructType\PcmSpeedLimitOptions
     */
    public function setVehicle($vehicle = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmVehicleType::valueIsValid($vehicle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicle, implode(', ', \Pcm\EnumType\PcmVehicleType::getValidValues())), __LINE__);
        }
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Urban value
     * @return bool|null
     */
    public function getUrban()
    {
        return $this->Urban;
    }
    /**
     * Set Urban value
     * @param bool $urban
     * @return \Pcm\StructType\PcmSpeedLimitOptions
     */
    public function setUrban($urban = null)
    {
        $this->Urban = $urban;
        return $this;
    }
    /**
     * Get IncludeLinkInfo value
     * @return bool|null
     */
    public function getIncludeLinkInfo()
    {
        return $this->IncludeLinkInfo;
    }
    /**
     * Set IncludeLinkInfo value
     * @param bool $includeLinkInfo
     * @return \Pcm\StructType\PcmSpeedLimitOptions
     */
    public function setIncludeLinkInfo($includeLinkInfo = null)
    {
        $this->IncludeLinkInfo = $includeLinkInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmSpeedLimitOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
