<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FuelOptions StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FuelOptions
 * @package Pcm
 * @subpackage Structs
 */
class PcmFuelOptions extends AbstractStructBase
{
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserID;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Account;
    /**
     * The FuelCap
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FuelCap;
    /**
     * The Level
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Level;
    /**
     * The MPG
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MPG;
    /**
     * Constructor method for FuelOptions
     * @uses PcmFuelOptions::setUserID()
     * @uses PcmFuelOptions::setPassword()
     * @uses PcmFuelOptions::setAccount()
     * @uses PcmFuelOptions::setFuelCap()
     * @uses PcmFuelOptions::setLevel()
     * @uses PcmFuelOptions::setMPG()
     * @param string $userID
     * @param string $password
     * @param string $account
     * @param float $fuelCap
     * @param float $level
     * @param float $mPG
     */
    public function __construct($userID = null, $password = null, $account = null, $fuelCap = null, $level = null, $mPG = null)
    {
        $this
            ->setUserID($userID)
            ->setPassword($password)
            ->setAccount($account)
            ->setFuelCap($fuelCap)
            ->setLevel($level)
            ->setMPG($mPG);
    }
    /**
     * Get UserID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserID()
    {
        return isset($this->UserID) ? $this->UserID : null;
    }
    /**
     * Set UserID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userID
     * @return \Pcm\StructType\PcmFuelOptions
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userID)), __LINE__);
        }
        if (is_null($userID) || (is_array($userID) && empty($userID))) {
            unset($this->UserID);
        } else {
            $this->UserID = $userID;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \Pcm\StructType\PcmFuelOptions
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $account
     * @return \Pcm\StructType\PcmFuelOptions
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($account)), __LINE__);
        }
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get FuelCap value
     * @return float|null
     */
    public function getFuelCap()
    {
        return $this->FuelCap;
    }
    /**
     * Set FuelCap value
     * @param float $fuelCap
     * @return \Pcm\StructType\PcmFuelOptions
     */
    public function setFuelCap($fuelCap = null)
    {
        $this->FuelCap = $fuelCap;
        return $this;
    }
    /**
     * Get Level value
     * @return float|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @param float $level
     * @return \Pcm\StructType\PcmFuelOptions
     */
    public function setLevel($level = null)
    {
        $this->Level = $level;
        return $this;
    }
    /**
     * Get MPG value
     * @return float|null
     */
    public function getMPG()
    {
        return $this->MPG;
    }
    /**
     * Set MPG value
     * @param float $mPG
     * @return \Pcm\StructType\PcmFuelOptions
     */
    public function setMPG($mPG = null)
    {
        $this->MPG = $mPG;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmFuelOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
