<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailReport StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DetailReport
 * @package Pcm
 * @subpackage Structs
 */
class PcmDetailReport extends PcmReport
{
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmGeocodeOutputLocation
     */
    public $Origin;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmGeocodeOutputLocation
     */
    public $Destination;
    /**
     * The ReportLegs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfDetailReportLeg
     */
    public $ReportLegs;
    /**
     * The TrafficDataUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TrafficDataUsed;
    /**
     * Constructor method for DetailReport
     * @uses PcmDetailReport::setOrigin()
     * @uses PcmDetailReport::setDestination()
     * @uses PcmDetailReport::setReportLegs()
     * @uses PcmDetailReport::setTrafficDataUsed()
     * @param \Pcm\StructType\PcmGeocodeOutputLocation $origin
     * @param \Pcm\StructType\PcmGeocodeOutputLocation $destination
     * @param \Pcm\ArrayType\PcmArrayOfDetailReportLeg $reportLegs
     * @param bool $trafficDataUsed
     */
    public function __construct(\Pcm\StructType\PcmGeocodeOutputLocation $origin = null, \Pcm\StructType\PcmGeocodeOutputLocation $destination = null, \Pcm\ArrayType\PcmArrayOfDetailReportLeg $reportLegs = null, $trafficDataUsed = null)
    {
        $this
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setReportLegs($reportLegs)
            ->setTrafficDataUsed($trafficDataUsed);
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmGeocodeOutputLocation|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmGeocodeOutputLocation $origin
     * @return \Pcm\StructType\PcmDetailReport
     */
    public function setOrigin(\Pcm\StructType\PcmGeocodeOutputLocation $origin = null)
    {
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmGeocodeOutputLocation|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmGeocodeOutputLocation $destination
     * @return \Pcm\StructType\PcmDetailReport
     */
    public function setDestination(\Pcm\StructType\PcmGeocodeOutputLocation $destination = null)
    {
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get ReportLegs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfDetailReportLeg|null
     */
    public function getReportLegs()
    {
        return isset($this->ReportLegs) ? $this->ReportLegs : null;
    }
    /**
     * Set ReportLegs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfDetailReportLeg $reportLegs
     * @return \Pcm\StructType\PcmDetailReport
     */
    public function setReportLegs(\Pcm\ArrayType\PcmArrayOfDetailReportLeg $reportLegs = null)
    {
        if (is_null($reportLegs) || (is_array($reportLegs) && empty($reportLegs))) {
            unset($this->ReportLegs);
        } else {
            $this->ReportLegs = $reportLegs;
        }
        return $this;
    }
    /**
     * Get TrafficDataUsed value
     * @return bool|null
     */
    public function getTrafficDataUsed()
    {
        return $this->TrafficDataUsed;
    }
    /**
     * Set TrafficDataUsed value
     * @param bool $trafficDataUsed
     * @return \Pcm\StructType\PcmDetailReport
     */
    public function setTrafficDataUsed($trafficDataUsed = null)
    {
        $this->TrafficDataUsed = $trafficDataUsed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmDetailReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
