<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ALKStyle StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ALKStyle
 * @package Pcm
 * @subpackage Structs
 */
class PcmALKStyle extends AbstractStructBase
{
    /**
     * The Font
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmALKFont
     */
    public $Font;
    /**
     * The Pen
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmALKPen
     */
    public $Pen;
    /**
     * The Brush
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmALKBrush
     */
    public $Brush;
    /**
     * The ImageShadow
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmALKShadow
     */
    public $ImageShadow;
    /**
     * The IndividualImageName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IndividualImageName;
    /**
     * The GroupImageName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupImageName;
    /**
     * Constructor method for ALKStyle
     * @uses PcmALKStyle::setFont()
     * @uses PcmALKStyle::setPen()
     * @uses PcmALKStyle::setBrush()
     * @uses PcmALKStyle::setImageShadow()
     * @uses PcmALKStyle::setIndividualImageName()
     * @uses PcmALKStyle::setGroupImageName()
     * @param \Pcm\StructType\PcmALKFont $font
     * @param \Pcm\StructType\PcmALKPen $pen
     * @param \Pcm\StructType\PcmALKBrush $brush
     * @param \Pcm\StructType\PcmALKShadow $imageShadow
     * @param string $individualImageName
     * @param string $groupImageName
     */
    public function __construct(\Pcm\StructType\PcmALKFont $font = null, \Pcm\StructType\PcmALKPen $pen = null, \Pcm\StructType\PcmALKBrush $brush = null, \Pcm\StructType\PcmALKShadow $imageShadow = null, $individualImageName = null, $groupImageName = null)
    {
        $this
            ->setFont($font)
            ->setPen($pen)
            ->setBrush($brush)
            ->setImageShadow($imageShadow)
            ->setIndividualImageName($individualImageName)
            ->setGroupImageName($groupImageName);
    }
    /**
     * Get Font value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmALKFont|null
     */
    public function getFont()
    {
        return isset($this->Font) ? $this->Font : null;
    }
    /**
     * Set Font value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmALKFont $font
     * @return \Pcm\StructType\PcmALKStyle
     */
    public function setFont(\Pcm\StructType\PcmALKFont $font = null)
    {
        if (is_null($font) || (is_array($font) && empty($font))) {
            unset($this->Font);
        } else {
            $this->Font = $font;
        }
        return $this;
    }
    /**
     * Get Pen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmALKPen|null
     */
    public function getPen()
    {
        return isset($this->Pen) ? $this->Pen : null;
    }
    /**
     * Set Pen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmALKPen $pen
     * @return \Pcm\StructType\PcmALKStyle
     */
    public function setPen(\Pcm\StructType\PcmALKPen $pen = null)
    {
        if (is_null($pen) || (is_array($pen) && empty($pen))) {
            unset($this->Pen);
        } else {
            $this->Pen = $pen;
        }
        return $this;
    }
    /**
     * Get Brush value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmALKBrush|null
     */
    public function getBrush()
    {
        return isset($this->Brush) ? $this->Brush : null;
    }
    /**
     * Set Brush value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmALKBrush $brush
     * @return \Pcm\StructType\PcmALKStyle
     */
    public function setBrush(\Pcm\StructType\PcmALKBrush $brush = null)
    {
        if (is_null($brush) || (is_array($brush) && empty($brush))) {
            unset($this->Brush);
        } else {
            $this->Brush = $brush;
        }
        return $this;
    }
    /**
     * Get ImageShadow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmALKShadow|null
     */
    public function getImageShadow()
    {
        return isset($this->ImageShadow) ? $this->ImageShadow : null;
    }
    /**
     * Set ImageShadow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmALKShadow $imageShadow
     * @return \Pcm\StructType\PcmALKStyle
     */
    public function setImageShadow(\Pcm\StructType\PcmALKShadow $imageShadow = null)
    {
        if (is_null($imageShadow) || (is_array($imageShadow) && empty($imageShadow))) {
            unset($this->ImageShadow);
        } else {
            $this->ImageShadow = $imageShadow;
        }
        return $this;
    }
    /**
     * Get IndividualImageName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndividualImageName()
    {
        return isset($this->IndividualImageName) ? $this->IndividualImageName : null;
    }
    /**
     * Set IndividualImageName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $individualImageName
     * @return \Pcm\StructType\PcmALKStyle
     */
    public function setIndividualImageName($individualImageName = null)
    {
        // validation for constraint: string
        if (!is_null($individualImageName) && !is_string($individualImageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($individualImageName)), __LINE__);
        }
        if (is_null($individualImageName) || (is_array($individualImageName) && empty($individualImageName))) {
            unset($this->IndividualImageName);
        } else {
            $this->IndividualImageName = $individualImageName;
        }
        return $this;
    }
    /**
     * Get GroupImageName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupImageName()
    {
        return isset($this->GroupImageName) ? $this->GroupImageName : null;
    }
    /**
     * Set GroupImageName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupImageName
     * @return \Pcm\StructType\PcmALKStyle
     */
    public function setGroupImageName($groupImageName = null)
    {
        // validation for constraint: string
        if (!is_null($groupImageName) && !is_string($groupImageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupImageName)), __LINE__);
        }
        if (is_null($groupImageName) || (is_array($groupImageName) && empty($groupImageName))) {
            unset($this->GroupImageName);
        } else {
            $this->GroupImageName = $groupImageName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmALKStyle
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
