<?php

namespace Pcm\EnumType;

/**
 * This class stands for WeatherAlertCertainty EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WeatherAlertCertainty
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmWeatherAlertCertainty
{
    /**
     * Constant for value 'Observed'
     * @return string 'Observed'
     */
    const VALUE_OBSERVED = 'Observed';
    /**
     * Constant for value 'Likely'
     * @return string 'Likely'
     */
    const VALUE_LIKELY = 'Likely';
    /**
     * Constant for value 'Possible'
     * @return string 'Possible'
     */
    const VALUE_POSSIBLE = 'Possible';
    /**
     * Constant for value 'Unlikely'
     * @return string 'Unlikely'
     */
    const VALUE_UNLIKELY = 'Unlikely';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OBSERVED
     * @uses self::VALUE_LIKELY
     * @uses self::VALUE_POSSIBLE
     * @uses self::VALUE_UNLIKELY
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OBSERVED,
            self::VALUE_LIKELY,
            self::VALUE_POSSIBLE,
            self::VALUE_UNLIKELY,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
