<?php

namespace Pcm\EnumType;

/**
 * This class stands for TrailerType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TrailerType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmTrailerType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Trailer'
     * @return string 'Trailer'
     */
    const VALUE_TRAILER = 'Trailer';
    /**
     * Constant for value 'Caravan'
     * @return string 'Caravan'
     */
    const VALUE_CARAVAN = 'Caravan';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_TRAILER
     * @uses self::VALUE_CARAVAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_TRAILER,
            self::VALUE_CARAVAN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
