<?php

namespace Pcm\EnumType;

/**
 * This class stands for RoutingType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoutingType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmRoutingType
{
    /**
     * Constant for value 'Practical'
     * @return string 'Practical'
     */
    const VALUE_PRACTICAL = 'Practical';
    /**
     * Constant for value 'Shortest'
     * @return string 'Shortest'
     */
    const VALUE_SHORTEST = 'Shortest';
    /**
     * Constant for value 'Fastest'
     * @return string 'Fastest'
     */
    const VALUE_FASTEST = 'Fastest';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRACTICAL
     * @uses self::VALUE_SHORTEST
     * @uses self::VALUE_FASTEST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRACTICAL,
            self::VALUE_SHORTEST,
            self::VALUE_FASTEST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
