<?php

namespace Pcm\EnumType;

/**
 * This class stands for MapRegion EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MapRegion
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmMapRegion
{
    /**
     * Constant for value 'NA'
     * @return string 'NA'
     */
    const VALUE_NA = 'NA';
    /**
     * Constant for value 'Bermuda'
     * @return string 'Bermuda'
     */
    const VALUE_BERMUDA = 'Bermuda';
    /**
     * Constant for value 'Canada'
     * @return string 'Canada'
     */
    const VALUE_CANADA = 'Canada';
    /**
     * Constant for value 'Mexico'
     * @return string 'Mexico'
     */
    const VALUE_MEXICO = 'Mexico';
    /**
     * Constant for value 'PuertoRico'
     * @return string 'PuertoRico'
     */
    const VALUE_PUERTO_RICO = 'PuertoRico';
    /**
     * Constant for value 'US'
     * @return string 'US'
     */
    const VALUE_US = 'US';
    /**
     * Constant for value 'EU'
     * @return string 'EU'
     */
    const VALUE_EU = 'EU';
    /**
     * Constant for value 'OC'
     * @return string 'OC'
     */
    const VALUE_OC = 'OC';
    /**
     * Constant for value 'ME'
     * @return string 'ME'
     */
    const VALUE_ME = 'ME';
    /**
     * Constant for value 'AF'
     * @return string 'AF'
     */
    const VALUE_AF = 'AF';
    /**
     * Constant for value 'SA'
     * @return string 'SA'
     */
    const VALUE_SA = 'SA';
    /**
     * Constant for value 'AS'
     * @return string 'AS'
     */
    const VALUE_AS = 'AS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NA
     * @uses self::VALUE_BERMUDA
     * @uses self::VALUE_CANADA
     * @uses self::VALUE_MEXICO
     * @uses self::VALUE_PUERTO_RICO
     * @uses self::VALUE_US
     * @uses self::VALUE_EU
     * @uses self::VALUE_OC
     * @uses self::VALUE_ME
     * @uses self::VALUE_AF
     * @uses self::VALUE_SA
     * @uses self::VALUE_AS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NA,
            self::VALUE_BERMUDA,
            self::VALUE_CANADA,
            self::VALUE_MEXICO,
            self::VALUE_PUERTO_RICO,
            self::VALUE_US,
            self::VALUE_EU,
            self::VALUE_OC,
            self::VALUE_ME,
            self::VALUE_AF,
            self::VALUE_SA,
            self::VALUE_AS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
