<?php

namespace Pcm\EnumType;

/**
 * This class stands for HoSScheduleType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HoSScheduleType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmHoSScheduleType
{
    /**
     * Constant for value 'USFed607LH'
     * @return string 'USFed607LH'
     */
    const VALUE_USFED_607_LH = 'USFed607LH';
    /**
     * Constant for value 'USFed708LH'
     * @return string 'USFed708LH'
     */
    const VALUE_USFED_708_LH = 'USFed708LH';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USFED_607_LH
     * @uses self::VALUE_USFED_708_LH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USFED_607_LH,
            self::VALUE_USFED_708_LH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
