<?php

namespace Pcm\EnumType;

/**
 * This class stands for DrawerType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DrawerType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmDrawerType
{
    /**
     * Constant for value 'Airports'
     * @return string 'Airports'
     */
    const VALUE_AIRPORTS = 'Airports';
    /**
     * Constant for value 'AvoidFavor'
     * @return string 'AvoidFavor'
     */
    const VALUE_AVOID_FAVOR = 'AvoidFavor';
    /**
     * Constant for value 'City'
     * @return string 'City'
     */
    const VALUE_CITY = 'City';
    /**
     * Constant for value 'CommerciallyProhibited'
     * @return string 'CommerciallyProhibited'
     */
    const VALUE_COMMERCIALLY_PROHIBITED = 'CommerciallyProhibited';
    /**
     * Constant for value 'CountryBoundaries'
     * @return string 'CountryBoundaries'
     */
    const VALUE_COUNTRY_BOUNDARIES = 'CountryBoundaries';
    /**
     * Constant for value 'CountyBoundaries'
     * @return string 'CountyBoundaries'
     */
    const VALUE_COUNTY_BOUNDARIES = 'CountyBoundaries';
    /**
     * Constant for value 'HazMat'
     * @return string 'HazMat'
     */
    const VALUE_HAZ_MAT = 'HazMat';
    /**
     * Constant for value 'Land'
     * @return string 'Land'
     */
    const VALUE_LAND = 'Land';
    /**
     * Constant for value 'LinkLabel'
     * @return string 'LinkLabel'
     */
    const VALUE_LINK_LABEL = 'LinkLabel';
    /**
     * Constant for value 'MilitaryBases'
     * @return string 'MilitaryBases'
     */
    const VALUE_MILITARY_BASES = 'MilitaryBases';
    /**
     * Constant for value 'Network'
     * @return string 'Network'
     */
    const VALUE_NETWORK = 'Network';
    /**
     * Constant for value 'OrthoImage'
     * @return string 'OrthoImage'
     */
    const VALUE_ORTHO_IMAGE = 'OrthoImage';
    /**
     * Constant for value 'Parks'
     * @return string 'Parks'
     */
    const VALUE_PARKS = 'Parks';
    /**
     * Constant for value 'Place'
     * @return string 'Place'
     */
    const VALUE_PLACE = 'Place';
    /**
     * Constant for value 'PointDrawerWeb'
     * @return string 'PointDrawerWeb'
     */
    const VALUE_POINT_DRAWER_WEB = 'PointDrawerWeb';
    /**
     * Constant for value 'Railroads'
     * @return string 'Railroads'
     */
    const VALUE_RAILROADS = 'Railroads';
    /**
     * Constant for value 'Route'
     * @return string 'Route'
     */
    const VALUE_ROUTE = 'Route';
    /**
     * Constant for value 'Shield'
     * @return string 'Shield'
     */
    const VALUE_SHIELD = 'Shield';
    /**
     * Constant for value 'StaaDesignation'
     * @return string 'StaaDesignation'
     */
    const VALUE_STAA_DESIGNATION = 'StaaDesignation';
    /**
     * Constant for value 'StateBoundaries'
     * @return string 'StateBoundaries'
     */
    const VALUE_STATE_BOUNDARIES = 'StateBoundaries';
    /**
     * Constant for value 'Stop'
     * @return string 'Stop'
     */
    const VALUE_STOP = 'Stop';
    /**
     * Constant for value 'TimeZone'
     * @return string 'TimeZone'
     */
    const VALUE_TIME_ZONE = 'TimeZone';
    /**
     * Constant for value 'TruckRestrictions'
     * @return string 'TruckRestrictions'
     */
    const VALUE_TRUCK_RESTRICTIONS = 'TruckRestrictions';
    /**
     * Constant for value 'UrbanAreas'
     * @return string 'UrbanAreas'
     */
    const VALUE_URBAN_AREAS = 'UrbanAreas';
    /**
     * Constant for value 'Water'
     * @return string 'Water'
     */
    const VALUE_WATER = 'Water';
    /**
     * Constant for value 'ExitLabel'
     * @return string 'ExitLabel'
     */
    const VALUE_EXIT_LABEL = 'ExitLabel';
    /**
     * Constant for value 'PolygonLabel'
     * @return string 'PolygonLabel'
     */
    const VALUE_POLYGON_LABEL = 'PolygonLabel';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIRPORTS
     * @uses self::VALUE_AVOID_FAVOR
     * @uses self::VALUE_CITY
     * @uses self::VALUE_COMMERCIALLY_PROHIBITED
     * @uses self::VALUE_COUNTRY_BOUNDARIES
     * @uses self::VALUE_COUNTY_BOUNDARIES
     * @uses self::VALUE_HAZ_MAT
     * @uses self::VALUE_LAND
     * @uses self::VALUE_LINK_LABEL
     * @uses self::VALUE_MILITARY_BASES
     * @uses self::VALUE_NETWORK
     * @uses self::VALUE_ORTHO_IMAGE
     * @uses self::VALUE_PARKS
     * @uses self::VALUE_PLACE
     * @uses self::VALUE_POINT_DRAWER_WEB
     * @uses self::VALUE_RAILROADS
     * @uses self::VALUE_ROUTE
     * @uses self::VALUE_SHIELD
     * @uses self::VALUE_STAA_DESIGNATION
     * @uses self::VALUE_STATE_BOUNDARIES
     * @uses self::VALUE_STOP
     * @uses self::VALUE_TIME_ZONE
     * @uses self::VALUE_TRUCK_RESTRICTIONS
     * @uses self::VALUE_URBAN_AREAS
     * @uses self::VALUE_WATER
     * @uses self::VALUE_EXIT_LABEL
     * @uses self::VALUE_POLYGON_LABEL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIRPORTS,
            self::VALUE_AVOID_FAVOR,
            self::VALUE_CITY,
            self::VALUE_COMMERCIALLY_PROHIBITED,
            self::VALUE_COUNTRY_BOUNDARIES,
            self::VALUE_COUNTY_BOUNDARIES,
            self::VALUE_HAZ_MAT,
            self::VALUE_LAND,
            self::VALUE_LINK_LABEL,
            self::VALUE_MILITARY_BASES,
            self::VALUE_NETWORK,
            self::VALUE_ORTHO_IMAGE,
            self::VALUE_PARKS,
            self::VALUE_PLACE,
            self::VALUE_POINT_DRAWER_WEB,
            self::VALUE_RAILROADS,
            self::VALUE_ROUTE,
            self::VALUE_SHIELD,
            self::VALUE_STAA_DESIGNATION,
            self::VALUE_STATE_BOUNDARIES,
            self::VALUE_STOP,
            self::VALUE_TIME_ZONE,
            self::VALUE_TRUCK_RESTRICTIONS,
            self::VALUE_URBAN_AREAS,
            self::VALUE_WATER,
            self::VALUE_EXIT_LABEL,
            self::VALUE_POLYGON_LABEL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
