<?php

namespace Pcm\EnumType;

/**
 * This class stands for DataRegion EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DataRegion
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmDataRegion
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'AF'
     * @return string 'AF'
     */
    const VALUE_AF = 'AF';
    /**
     * Constant for value 'AS'
     * @return string 'AS'
     */
    const VALUE_AS = 'AS';
    /**
     * Constant for value 'EU'
     * @return string 'EU'
     */
    const VALUE_EU = 'EU';
    /**
     * Constant for value 'NA'
     * @return string 'NA'
     */
    const VALUE_NA = 'NA';
    /**
     * Constant for value 'OC'
     * @return string 'OC'
     */
    const VALUE_OC = 'OC';
    /**
     * Constant for value 'SA'
     * @return string 'SA'
     */
    const VALUE_SA = 'SA';
    /**
     * Constant for value 'ME'
     * @return string 'ME'
     */
    const VALUE_ME = 'ME';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_AF
     * @uses self::VALUE_AS
     * @uses self::VALUE_EU
     * @uses self::VALUE_NA
     * @uses self::VALUE_OC
     * @uses self::VALUE_SA
     * @uses self::VALUE_ME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_AF,
            self::VALUE_AS,
            self::VALUE_EU,
            self::VALUE_NA,
            self::VALUE_OC,
            self::VALUE_SA,
            self::VALUE_ME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
