<?php

namespace Pcm\EnumType;

/**
 * This class stands for CountryAbbreviationType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CountryAbbreviationType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmCountryAbbreviationType
{
    /**
     * Constant for value 'FIPS'
     * @return string 'FIPS'
     */
    const VALUE_FIPS = 'FIPS';
    /**
     * Constant for value 'ISO2'
     * @return string 'ISO2'
     */
    const VALUE_ISO_2 = 'ISO2';
    /**
     * Constant for value 'ISO3'
     * @return string 'ISO3'
     */
    const VALUE_ISO_3 = 'ISO3';
    /**
     * Constant for value 'GENC2'
     * @return string 'GENC2'
     */
    const VALUE_GENC_2 = 'GENC2';
    /**
     * Constant for value 'GENC3'
     * @return string 'GENC3'
     */
    const VALUE_GENC_3 = 'GENC3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIPS
     * @uses self::VALUE_ISO_2
     * @uses self::VALUE_ISO_3
     * @uses self::VALUE_GENC_2
     * @uses self::VALUE_GENC_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIPS,
            self::VALUE_ISO_2,
            self::VALUE_ISO_3,
            self::VALUE_GENC_2,
            self::VALUE_GENC_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
