<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WeatherAlertsReportType StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WeatherAlertsReportType
 * @package Pcm
 * @subpackage Structs
 */
class PcmWeatherAlertsReportType extends PcmReportType
{
    /**
     * The Urgency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Urgency;
    /**
     * The Severity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Severity;
    /**
     * The Certainty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Certainty;
    /**
     * The EventNames
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfstring
     */
    public $EventNames;
    /**
     * Constructor method for WeatherAlertsReportType
     * @uses PcmWeatherAlertsReportType::setUrgency()
     * @uses PcmWeatherAlertsReportType::setSeverity()
     * @uses PcmWeatherAlertsReportType::setCertainty()
     * @uses PcmWeatherAlertsReportType::setEventNames()
     * @param string $urgency
     * @param string $severity
     * @param string $certainty
     * @param \Pcm\ArrayType\PcmArrayOfstring $eventNames
     */
    public function __construct($urgency = null, $severity = null, $certainty = null, \Pcm\ArrayType\PcmArrayOfstring $eventNames = null)
    {
        $this
            ->setUrgency($urgency)
            ->setSeverity($severity)
            ->setCertainty($certainty)
            ->setEventNames($eventNames);
    }
    /**
     * Get Urgency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrgency()
    {
        return isset($this->Urgency) ? $this->Urgency : null;
    }
    /**
     * Set Urgency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pcm\EnumType\PcmWeatherAlertUrgency::valueIsValid()
     * @uses \Pcm\EnumType\PcmWeatherAlertUrgency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $urgency
     * @return \Pcm\StructType\PcmWeatherAlertsReportType
     */
    public function setUrgency($urgency = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmWeatherAlertUrgency::valueIsValid($urgency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $urgency, implode(', ', \Pcm\EnumType\PcmWeatherAlertUrgency::getValidValues())), __LINE__);
        }
        if (is_null($urgency) || (is_array($urgency) && empty($urgency))) {
            unset($this->Urgency);
        } else {
            $this->Urgency = $urgency;
        }
        return $this;
    }
    /**
     * Get Severity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeverity()
    {
        return isset($this->Severity) ? $this->Severity : null;
    }
    /**
     * Set Severity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pcm\EnumType\PcmWeatherAlertSeverity::valueIsValid()
     * @uses \Pcm\EnumType\PcmWeatherAlertSeverity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $severity
     * @return \Pcm\StructType\PcmWeatherAlertsReportType
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmWeatherAlertSeverity::valueIsValid($severity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $severity, implode(', ', \Pcm\EnumType\PcmWeatherAlertSeverity::getValidValues())), __LINE__);
        }
        if (is_null($severity) || (is_array($severity) && empty($severity))) {
            unset($this->Severity);
        } else {
            $this->Severity = $severity;
        }
        return $this;
    }
    /**
     * Get Certainty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCertainty()
    {
        return isset($this->Certainty) ? $this->Certainty : null;
    }
    /**
     * Set Certainty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pcm\EnumType\PcmWeatherAlertCertainty::valueIsValid()
     * @uses \Pcm\EnumType\PcmWeatherAlertCertainty::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certainty
     * @return \Pcm\StructType\PcmWeatherAlertsReportType
     */
    public function setCertainty($certainty = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmWeatherAlertCertainty::valueIsValid($certainty)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certainty, implode(', ', \Pcm\EnumType\PcmWeatherAlertCertainty::getValidValues())), __LINE__);
        }
        if (is_null($certainty) || (is_array($certainty) && empty($certainty))) {
            unset($this->Certainty);
        } else {
            $this->Certainty = $certainty;
        }
        return $this;
    }
    /**
     * Get EventNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfstring|null
     */
    public function getEventNames()
    {
        return isset($this->EventNames) ? $this->EventNames : null;
    }
    /**
     * Set EventNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfstring $eventNames
     * @return \Pcm\StructType\PcmWeatherAlertsReportType
     */
    public function setEventNames(\Pcm\ArrayType\PcmArrayOfstring $eventNames = null)
    {
        if (is_null($eventNames) || (is_array($eventNames) && empty($eventNames))) {
            unset($this->EventNames);
        } else {
            $this->EventNames = $eventNames;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmWeatherAlertsReportType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
