<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TollDetailReportSegmentLine StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TollDetailReportSegmentLine
 * @package Pcm
 * @subpackage Structs
 */
class PcmTollDetailReportSegmentLine extends AbstractStructBase
{
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The Road
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Road;
    /**
     * The TollName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TollName;
    /**
     * The DistanceBased
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DistanceBased;
    /**
     * The Pass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Pass;
    /**
     * The Flat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Flat;
    /**
     * Constructor method for TollDetailReportSegmentLine
     * @uses PcmTollDetailReportSegmentLine::setCountry()
     * @uses PcmTollDetailReportSegmentLine::setRoad()
     * @uses PcmTollDetailReportSegmentLine::setTollName()
     * @uses PcmTollDetailReportSegmentLine::setDistanceBased()
     * @uses PcmTollDetailReportSegmentLine::setPass()
     * @uses PcmTollDetailReportSegmentLine::setFlat()
     * @param string $country
     * @param string $road
     * @param string $tollName
     * @param string $distanceBased
     * @param string $pass
     * @param string $flat
     */
    public function __construct($country = null, $road = null, $tollName = null, $distanceBased = null, $pass = null, $flat = null)
    {
        $this
            ->setCountry($country)
            ->setRoad($road)
            ->setTollName($tollName)
            ->setDistanceBased($distanceBased)
            ->setPass($pass)
            ->setFlat($flat);
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \Pcm\StructType\PcmTollDetailReportSegmentLine
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get Road value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoad()
    {
        return isset($this->Road) ? $this->Road : null;
    }
    /**
     * Set Road value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $road
     * @return \Pcm\StructType\PcmTollDetailReportSegmentLine
     */
    public function setRoad($road = null)
    {
        // validation for constraint: string
        if (!is_null($road) && !is_string($road)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road)), __LINE__);
        }
        if (is_null($road) || (is_array($road) && empty($road))) {
            unset($this->Road);
        } else {
            $this->Road = $road;
        }
        return $this;
    }
    /**
     * Get TollName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTollName()
    {
        return isset($this->TollName) ? $this->TollName : null;
    }
    /**
     * Set TollName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tollName
     * @return \Pcm\StructType\PcmTollDetailReportSegmentLine
     */
    public function setTollName($tollName = null)
    {
        // validation for constraint: string
        if (!is_null($tollName) && !is_string($tollName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tollName)), __LINE__);
        }
        if (is_null($tollName) || (is_array($tollName) && empty($tollName))) {
            unset($this->TollName);
        } else {
            $this->TollName = $tollName;
        }
        return $this;
    }
    /**
     * Get DistanceBased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDistanceBased()
    {
        return isset($this->DistanceBased) ? $this->DistanceBased : null;
    }
    /**
     * Set DistanceBased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $distanceBased
     * @return \Pcm\StructType\PcmTollDetailReportSegmentLine
     */
    public function setDistanceBased($distanceBased = null)
    {
        // validation for constraint: string
        if (!is_null($distanceBased) && !is_string($distanceBased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceBased)), __LINE__);
        }
        if (is_null($distanceBased) || (is_array($distanceBased) && empty($distanceBased))) {
            unset($this->DistanceBased);
        } else {
            $this->DistanceBased = $distanceBased;
        }
        return $this;
    }
    /**
     * Get Pass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPass()
    {
        return isset($this->Pass) ? $this->Pass : null;
    }
    /**
     * Set Pass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pass
     * @return \Pcm\StructType\PcmTollDetailReportSegmentLine
     */
    public function setPass($pass = null)
    {
        // validation for constraint: string
        if (!is_null($pass) && !is_string($pass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pass)), __LINE__);
        }
        if (is_null($pass) || (is_array($pass) && empty($pass))) {
            unset($this->Pass);
        } else {
            $this->Pass = $pass;
        }
        return $this;
    }
    /**
     * Get Flat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlat()
    {
        return isset($this->Flat) ? $this->Flat : null;
    }
    /**
     * Set Flat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flat
     * @return \Pcm\StructType\PcmTollDetailReportSegmentLine
     */
    public function setFlat($flat = null)
    {
        // validation for constraint: string
        if (!is_null($flat) && !is_string($flat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flat)), __LINE__);
        }
        if (is_null($flat) || (is_array($flat) && empty($flat))) {
            unset($this->Flat);
        } else {
            $this->Flat = $flat;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmTollDetailReportSegmentLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
