<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PinCategory StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PinCategory
 * @package Pcm
 * @subpackage Structs
 */
class PcmPinCategory extends AbstractStructBase
{
    /**
     * The ImageName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageName;
    /**
     * The ImageNameForIndividual
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageNameForIndividual;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The PinType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PinType;
    /**
     * The Style
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmALKStyle
     */
    public $Style;
    /**
     * The ZOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ZOrder;
    /**
     * Constructor method for PinCategory
     * @uses PcmPinCategory::setImageName()
     * @uses PcmPinCategory::setImageNameForIndividual()
     * @uses PcmPinCategory::setName()
     * @uses PcmPinCategory::setPinType()
     * @uses PcmPinCategory::setStyle()
     * @uses PcmPinCategory::setZOrder()
     * @param string $imageName
     * @param string $imageNameForIndividual
     * @param string $name
     * @param string $pinType
     * @param \Pcm\StructType\PcmALKStyle $style
     * @param int $zOrder
     */
    public function __construct($imageName = null, $imageNameForIndividual = null, $name = null, $pinType = null, \Pcm\StructType\PcmALKStyle $style = null, $zOrder = null)
    {
        $this
            ->setImageName($imageName)
            ->setImageNameForIndividual($imageNameForIndividual)
            ->setName($name)
            ->setPinType($pinType)
            ->setStyle($style)
            ->setZOrder($zOrder);
    }
    /**
     * Get ImageName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageName()
    {
        return isset($this->ImageName) ? $this->ImageName : null;
    }
    /**
     * Set ImageName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageName
     * @return \Pcm\StructType\PcmPinCategory
     */
    public function setImageName($imageName = null)
    {
        // validation for constraint: string
        if (!is_null($imageName) && !is_string($imageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageName)), __LINE__);
        }
        if (is_null($imageName) || (is_array($imageName) && empty($imageName))) {
            unset($this->ImageName);
        } else {
            $this->ImageName = $imageName;
        }
        return $this;
    }
    /**
     * Get ImageNameForIndividual value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageNameForIndividual()
    {
        return isset($this->ImageNameForIndividual) ? $this->ImageNameForIndividual : null;
    }
    /**
     * Set ImageNameForIndividual value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageNameForIndividual
     * @return \Pcm\StructType\PcmPinCategory
     */
    public function setImageNameForIndividual($imageNameForIndividual = null)
    {
        // validation for constraint: string
        if (!is_null($imageNameForIndividual) && !is_string($imageNameForIndividual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageNameForIndividual)), __LINE__);
        }
        if (is_null($imageNameForIndividual) || (is_array($imageNameForIndividual) && empty($imageNameForIndividual))) {
            unset($this->ImageNameForIndividual);
        } else {
            $this->ImageNameForIndividual = $imageNameForIndividual;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \Pcm\StructType\PcmPinCategory
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PinType value
     * @return string|null
     */
    public function getPinType()
    {
        return $this->PinType;
    }
    /**
     * Set PinType value
     * @uses \Pcm\EnumType\PcmPinType::valueIsValid()
     * @uses \Pcm\EnumType\PcmPinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pinType
     * @return \Pcm\StructType\PcmPinCategory
     */
    public function setPinType($pinType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmPinType::valueIsValid($pinType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pinType, implode(', ', \Pcm\EnumType\PcmPinType::getValidValues())), __LINE__);
        }
        $this->PinType = $pinType;
        return $this;
    }
    /**
     * Get Style value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmALKStyle|null
     */
    public function getStyle()
    {
        return isset($this->Style) ? $this->Style : null;
    }
    /**
     * Set Style value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmALKStyle $style
     * @return \Pcm\StructType\PcmPinCategory
     */
    public function setStyle(\Pcm\StructType\PcmALKStyle $style = null)
    {
        if (is_null($style) || (is_array($style) && empty($style))) {
            unset($this->Style);
        } else {
            $this->Style = $style;
        }
        return $this;
    }
    /**
     * Get ZOrder value
     * @return int|null
     */
    public function getZOrder()
    {
        return $this->ZOrder;
    }
    /**
     * Set ZOrder value
     * @param int $zOrder
     * @return \Pcm\StructType\PcmPinCategory
     */
    public function setZOrder($zOrder = null)
    {
        // validation for constraint: int
        if (!is_null($zOrder) && !is_numeric($zOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($zOrder)), __LINE__);
        }
        $this->ZOrder = $zOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmPinCategory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
