<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapRoute StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MapRoute
 * @package Pcm
 * @subpackage Structs
 */
class PcmMapRoute extends PcmRoute
{
    /**
     * The DrawLeastCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DrawLeastCost;
    /**
     * The RouteLegOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRouteLegOptions
     */
    public $RouteLegOptions;
    /**
     * The StopLabelDrawer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StopLabelDrawer;
    /**
     * Constructor method for MapRoute
     * @uses PcmMapRoute::setDrawLeastCost()
     * @uses PcmMapRoute::setRouteLegOptions()
     * @uses PcmMapRoute::setStopLabelDrawer()
     * @param bool $drawLeastCost
     * @param \Pcm\StructType\PcmRouteLegOptions $routeLegOptions
     * @param string $stopLabelDrawer
     */
    public function __construct($drawLeastCost = null, \Pcm\StructType\PcmRouteLegOptions $routeLegOptions = null, $stopLabelDrawer = null)
    {
        $this
            ->setDrawLeastCost($drawLeastCost)
            ->setRouteLegOptions($routeLegOptions)
            ->setStopLabelDrawer($stopLabelDrawer);
    }
    /**
     * Get DrawLeastCost value
     * @return bool|null
     */
    public function getDrawLeastCost()
    {
        return $this->DrawLeastCost;
    }
    /**
     * Set DrawLeastCost value
     * @param bool $drawLeastCost
     * @return \Pcm\StructType\PcmMapRoute
     */
    public function setDrawLeastCost($drawLeastCost = null)
    {
        // validation for constraint: boolean
        if (!is_null($drawLeastCost) && !is_bool($drawLeastCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($drawLeastCost)), __LINE__);
        }
        $this->DrawLeastCost = $drawLeastCost;
        return $this;
    }
    /**
     * Get RouteLegOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRouteLegOptions|null
     */
    public function getRouteLegOptions()
    {
        return isset($this->RouteLegOptions) ? $this->RouteLegOptions : null;
    }
    /**
     * Set RouteLegOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmRouteLegOptions $routeLegOptions
     * @return \Pcm\StructType\PcmMapRoute
     */
    public function setRouteLegOptions(\Pcm\StructType\PcmRouteLegOptions $routeLegOptions = null)
    {
        if (is_null($routeLegOptions) || (is_array($routeLegOptions) && empty($routeLegOptions))) {
            unset($this->RouteLegOptions);
        } else {
            $this->RouteLegOptions = $routeLegOptions;
        }
        return $this;
    }
    /**
     * Get StopLabelDrawer value
     * @return string|null
     */
    public function getStopLabelDrawer()
    {
        return $this->StopLabelDrawer;
    }
    /**
     * Set StopLabelDrawer value
     * @uses \Pcm\EnumType\PcmStopLabelType::valueIsValid()
     * @uses \Pcm\EnumType\PcmStopLabelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopLabelDrawer
     * @return \Pcm\StructType\PcmMapRoute
     */
    public function setStopLabelDrawer($stopLabelDrawer = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmStopLabelType::valueIsValid($stopLabelDrawer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stopLabelDrawer, implode(', ', \Pcm\EnumType\PcmStopLabelType::getValidValues())), __LINE__);
        }
        $this->StopLabelDrawer = $stopLabelDrawer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmMapRoute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
