<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapPointInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MapPointInfo
 * @package Pcm
 * @subpackage Structs
 */
class PcmMapPointInfo extends AbstractStructBase
{
    /**
     * The ClassName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClassName;
    /**
     * The DevX
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DevX;
    /**
     * The DevY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DevY;
    /**
     * The GroupID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GroupID;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Longitude;
    /**
     * Constructor method for MapPointInfo
     * @uses PcmMapPointInfo::setClassName()
     * @uses PcmMapPointInfo::setDevX()
     * @uses PcmMapPointInfo::setDevY()
     * @uses PcmMapPointInfo::setGroupID()
     * @uses PcmMapPointInfo::setID()
     * @uses PcmMapPointInfo::setLatitude()
     * @uses PcmMapPointInfo::setLongitude()
     * @param string $className
     * @param int $devX
     * @param int $devY
     * @param int $groupID
     * @param int $iD
     * @param int $latitude
     * @param int $longitude
     */
    public function __construct($className = null, $devX = null, $devY = null, $groupID = null, $iD = null, $latitude = null, $longitude = null)
    {
        $this
            ->setClassName($className)
            ->setDevX($devX)
            ->setDevY($devY)
            ->setGroupID($groupID)
            ->setID($iD)
            ->setLatitude($latitude)
            ->setLongitude($longitude);
    }
    /**
     * Get ClassName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClassName()
    {
        return isset($this->ClassName) ? $this->ClassName : null;
    }
    /**
     * Set ClassName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $className
     * @return \Pcm\StructType\PcmMapPointInfo
     */
    public function setClassName($className = null)
    {
        // validation for constraint: string
        if (!is_null($className) && !is_string($className)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($className)), __LINE__);
        }
        if (is_null($className) || (is_array($className) && empty($className))) {
            unset($this->ClassName);
        } else {
            $this->ClassName = $className;
        }
        return $this;
    }
    /**
     * Get DevX value
     * @return int|null
     */
    public function getDevX()
    {
        return $this->DevX;
    }
    /**
     * Set DevX value
     * @param int $devX
     * @return \Pcm\StructType\PcmMapPointInfo
     */
    public function setDevX($devX = null)
    {
        // validation for constraint: int
        if (!is_null($devX) && !is_numeric($devX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($devX)), __LINE__);
        }
        $this->DevX = $devX;
        return $this;
    }
    /**
     * Get DevY value
     * @return int|null
     */
    public function getDevY()
    {
        return $this->DevY;
    }
    /**
     * Set DevY value
     * @param int $devY
     * @return \Pcm\StructType\PcmMapPointInfo
     */
    public function setDevY($devY = null)
    {
        // validation for constraint: int
        if (!is_null($devY) && !is_numeric($devY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($devY)), __LINE__);
        }
        $this->DevY = $devY;
        return $this;
    }
    /**
     * Get GroupID value
     * @return int|null
     */
    public function getGroupID()
    {
        return $this->GroupID;
    }
    /**
     * Set GroupID value
     * @param int $groupID
     * @return \Pcm\StructType\PcmMapPointInfo
     */
    public function setGroupID($groupID = null)
    {
        // validation for constraint: int
        if (!is_null($groupID) && !is_numeric($groupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupID)), __LINE__);
        }
        $this->GroupID = $groupID;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Pcm\StructType\PcmMapPointInfo
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Latitude value
     * @return int|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param int $latitude
     * @return \Pcm\StructType\PcmMapPointInfo
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: int
        if (!is_null($latitude) && !is_numeric($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return int|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param int $longitude
     * @return \Pcm\StructType\PcmMapPointInfo
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: int
        if (!is_null($longitude) && !is_numeric($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmMapPointInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
