<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapGroupInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MapGroupInfo
 * @package Pcm
 * @subpackage Structs
 */
class PcmMapGroupInfo extends AbstractStructBase
{
    /**
     * The DevX
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DevX;
    /**
     * The DevY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DevY;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Longitude;
    /**
     * The MaxLat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxLat;
    /**
     * The MaxLon
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxLon;
    /**
     * The MinLat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinLat;
    /**
     * The MinLon
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinLon;
    /**
     * The NumPoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumPoints;
    /**
     * Constructor method for MapGroupInfo
     * @uses PcmMapGroupInfo::setDevX()
     * @uses PcmMapGroupInfo::setDevY()
     * @uses PcmMapGroupInfo::setID()
     * @uses PcmMapGroupInfo::setLatitude()
     * @uses PcmMapGroupInfo::setLongitude()
     * @uses PcmMapGroupInfo::setMaxLat()
     * @uses PcmMapGroupInfo::setMaxLon()
     * @uses PcmMapGroupInfo::setMinLat()
     * @uses PcmMapGroupInfo::setMinLon()
     * @uses PcmMapGroupInfo::setNumPoints()
     * @param int $devX
     * @param int $devY
     * @param int $iD
     * @param int $latitude
     * @param int $longitude
     * @param int $maxLat
     * @param int $maxLon
     * @param int $minLat
     * @param int $minLon
     * @param int $numPoints
     */
    public function __construct($devX = null, $devY = null, $iD = null, $latitude = null, $longitude = null, $maxLat = null, $maxLon = null, $minLat = null, $minLon = null, $numPoints = null)
    {
        $this
            ->setDevX($devX)
            ->setDevY($devY)
            ->setID($iD)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setMaxLat($maxLat)
            ->setMaxLon($maxLon)
            ->setMinLat($minLat)
            ->setMinLon($minLon)
            ->setNumPoints($numPoints);
    }
    /**
     * Get DevX value
     * @return int|null
     */
    public function getDevX()
    {
        return $this->DevX;
    }
    /**
     * Set DevX value
     * @param int $devX
     * @return \Pcm\StructType\PcmMapGroupInfo
     */
    public function setDevX($devX = null)
    {
        // validation for constraint: int
        if (!is_null($devX) && !is_numeric($devX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($devX)), __LINE__);
        }
        $this->DevX = $devX;
        return $this;
    }
    /**
     * Get DevY value
     * @return int|null
     */
    public function getDevY()
    {
        return $this->DevY;
    }
    /**
     * Set DevY value
     * @param int $devY
     * @return \Pcm\StructType\PcmMapGroupInfo
     */
    public function setDevY($devY = null)
    {
        // validation for constraint: int
        if (!is_null($devY) && !is_numeric($devY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($devY)), __LINE__);
        }
        $this->DevY = $devY;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Pcm\StructType\PcmMapGroupInfo
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Latitude value
     * @return int|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param int $latitude
     * @return \Pcm\StructType\PcmMapGroupInfo
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: int
        if (!is_null($latitude) && !is_numeric($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return int|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param int $longitude
     * @return \Pcm\StructType\PcmMapGroupInfo
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: int
        if (!is_null($longitude) && !is_numeric($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get MaxLat value
     * @return int|null
     */
    public function getMaxLat()
    {
        return $this->MaxLat;
    }
    /**
     * Set MaxLat value
     * @param int $maxLat
     * @return \Pcm\StructType\PcmMapGroupInfo
     */
    public function setMaxLat($maxLat = null)
    {
        // validation for constraint: int
        if (!is_null($maxLat) && !is_numeric($maxLat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxLat)), __LINE__);
        }
        $this->MaxLat = $maxLat;
        return $this;
    }
    /**
     * Get MaxLon value
     * @return int|null
     */
    public function getMaxLon()
    {
        return $this->MaxLon;
    }
    /**
     * Set MaxLon value
     * @param int $maxLon
     * @return \Pcm\StructType\PcmMapGroupInfo
     */
    public function setMaxLon($maxLon = null)
    {
        // validation for constraint: int
        if (!is_null($maxLon) && !is_numeric($maxLon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxLon)), __LINE__);
        }
        $this->MaxLon = $maxLon;
        return $this;
    }
    /**
     * Get MinLat value
     * @return int|null
     */
    public function getMinLat()
    {
        return $this->MinLat;
    }
    /**
     * Set MinLat value
     * @param int $minLat
     * @return \Pcm\StructType\PcmMapGroupInfo
     */
    public function setMinLat($minLat = null)
    {
        // validation for constraint: int
        if (!is_null($minLat) && !is_numeric($minLat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minLat)), __LINE__);
        }
        $this->MinLat = $minLat;
        return $this;
    }
    /**
     * Get MinLon value
     * @return int|null
     */
    public function getMinLon()
    {
        return $this->MinLon;
    }
    /**
     * Set MinLon value
     * @param int $minLon
     * @return \Pcm\StructType\PcmMapGroupInfo
     */
    public function setMinLon($minLon = null)
    {
        // validation for constraint: int
        if (!is_null($minLon) && !is_numeric($minLon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minLon)), __LINE__);
        }
        $this->MinLon = $minLon;
        return $this;
    }
    /**
     * Get NumPoints value
     * @return int|null
     */
    public function getNumPoints()
    {
        return $this->NumPoints;
    }
    /**
     * Set NumPoints value
     * @param int $numPoints
     * @return \Pcm\StructType\PcmMapGroupInfo
     */
    public function setNumPoints($numPoints = null)
    {
        // validation for constraint: int
        if (!is_null($numPoints) && !is_numeric($numPoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numPoints)), __LINE__);
        }
        $this->NumPoints = $numPoints;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmMapGroupInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
