<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvoidFavorSetRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvoidFavorSetRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmGetAvoidFavorSetRequestBody extends PcmCustomDataSetRequestBody
{
    /**
     * The Detail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Detail;
    /**
     * The Corner1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates
     */
    public $Corner1;
    /**
     * The Corner2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates
     */
    public $Corner2;
    /**
     * The PLIDOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PLIDOnly;
    /**
     * The InexactNameMatch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $InexactNameMatch;
    /**
     * Constructor method for GetAvoidFavorSetRequestBody
     * @uses PcmGetAvoidFavorSetRequestBody::setDetail()
     * @uses PcmGetAvoidFavorSetRequestBody::setCorner1()
     * @uses PcmGetAvoidFavorSetRequestBody::setCorner2()
     * @uses PcmGetAvoidFavorSetRequestBody::setPLIDOnly()
     * @uses PcmGetAvoidFavorSetRequestBody::setInexactNameMatch()
     * @param bool $detail
     * @param \Pcm\StructType\PcmCoordinates $corner1
     * @param \Pcm\StructType\PcmCoordinates $corner2
     * @param bool $pLIDOnly
     * @param bool $inexactNameMatch
     */
    public function __construct($detail = null, \Pcm\StructType\PcmCoordinates $corner1 = null, \Pcm\StructType\PcmCoordinates $corner2 = null, $pLIDOnly = null, $inexactNameMatch = null)
    {
        $this
            ->setDetail($detail)
            ->setCorner1($corner1)
            ->setCorner2($corner2)
            ->setPLIDOnly($pLIDOnly)
            ->setInexactNameMatch($inexactNameMatch);
    }
    /**
     * Get Detail value
     * @return bool|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @param bool $detail
     * @return \Pcm\StructType\PcmGetAvoidFavorSetRequestBody
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: boolean
        if (!is_null($detail) && !is_bool($detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($detail)), __LINE__);
        }
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Get Corner1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function getCorner1()
    {
        return isset($this->Corner1) ? $this->Corner1 : null;
    }
    /**
     * Set Corner1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmCoordinates $corner1
     * @return \Pcm\StructType\PcmGetAvoidFavorSetRequestBody
     */
    public function setCorner1(\Pcm\StructType\PcmCoordinates $corner1 = null)
    {
        if (is_null($corner1) || (is_array($corner1) && empty($corner1))) {
            unset($this->Corner1);
        } else {
            $this->Corner1 = $corner1;
        }
        return $this;
    }
    /**
     * Get Corner2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function getCorner2()
    {
        return isset($this->Corner2) ? $this->Corner2 : null;
    }
    /**
     * Set Corner2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmCoordinates $corner2
     * @return \Pcm\StructType\PcmGetAvoidFavorSetRequestBody
     */
    public function setCorner2(\Pcm\StructType\PcmCoordinates $corner2 = null)
    {
        if (is_null($corner2) || (is_array($corner2) && empty($corner2))) {
            unset($this->Corner2);
        } else {
            $this->Corner2 = $corner2;
        }
        return $this;
    }
    /**
     * Get PLIDOnly value
     * @return bool|null
     */
    public function getPLIDOnly()
    {
        return $this->PLIDOnly;
    }
    /**
     * Set PLIDOnly value
     * @param bool $pLIDOnly
     * @return \Pcm\StructType\PcmGetAvoidFavorSetRequestBody
     */
    public function setPLIDOnly($pLIDOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($pLIDOnly) && !is_bool($pLIDOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($pLIDOnly)), __LINE__);
        }
        $this->PLIDOnly = $pLIDOnly;
        return $this;
    }
    /**
     * Get InexactNameMatch value
     * @return bool|null
     */
    public function getInexactNameMatch()
    {
        return $this->InexactNameMatch;
    }
    /**
     * Set InexactNameMatch value
     * @param bool $inexactNameMatch
     * @return \Pcm\StructType\PcmGetAvoidFavorSetRequestBody
     */
    public function setInexactNameMatch($inexactNameMatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($inexactNameMatch) && !is_bool($inexactNameMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inexactNameMatch)), __LINE__);
        }
        $this->InexactNameMatch = $inexactNameMatch;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmGetAvoidFavorSetRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
