<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtendedRoute StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ExtendedRoute
 * @package Pcm
 * @subpackage Structs
 */
class PcmExtendedRoute extends PcmRoute
{
    /**
     * The ExtendedOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmSharedOptions
     */
    public $ExtendedOptions;
    /**
     * Constructor method for ExtendedRoute
     * @uses PcmExtendedRoute::setExtendedOptions()
     * @param \Pcm\StructType\PcmSharedOptions $extendedOptions
     */
    public function __construct(\Pcm\StructType\PcmSharedOptions $extendedOptions = null)
    {
        $this
            ->setExtendedOptions($extendedOptions);
    }
    /**
     * Get ExtendedOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmSharedOptions|null
     */
    public function getExtendedOptions()
    {
        return isset($this->ExtendedOptions) ? $this->ExtendedOptions : null;
    }
    /**
     * Set ExtendedOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmSharedOptions $extendedOptions
     * @return \Pcm\StructType\PcmExtendedRoute
     */
    public function setExtendedOptions(\Pcm\StructType\PcmSharedOptions $extendedOptions = null)
    {
        if (is_null($extendedOptions) || (is_array($extendedOptions) && empty($extendedOptions))) {
            unset($this->ExtendedOptions);
        } else {
            $this->ExtendedOptions = $extendedOptions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmExtendedRoute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
