<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedTimeOptions StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EstimatedTimeOptions
 * @package Pcm
 * @subpackage Structs
 */
class PcmEstimatedTimeOptions extends AbstractStructBase
{
    /**
     * The ETAETD
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ETAETD;
    /**
     * The DateOption
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateOption;
    /**
     * The DateAndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmDateTimeType
     */
    public $DateAndTime;
    /**
     * Constructor method for EstimatedTimeOptions
     * @uses PcmEstimatedTimeOptions::setETAETD()
     * @uses PcmEstimatedTimeOptions::setDateOption()
     * @uses PcmEstimatedTimeOptions::setDateAndTime()
     * @param string $eTAETD
     * @param string $dateOption
     * @param \Pcm\StructType\PcmDateTimeType $dateAndTime
     */
    public function __construct($eTAETD = null, $dateOption = null, \Pcm\StructType\PcmDateTimeType $dateAndTime = null)
    {
        $this
            ->setETAETD($eTAETD)
            ->setDateOption($dateOption)
            ->setDateAndTime($dateAndTime);
    }
    /**
     * Get ETAETD value
     * @return string|null
     */
    public function getETAETD()
    {
        return $this->ETAETD;
    }
    /**
     * Set ETAETD value
     * @uses \Pcm\EnumType\PcmETAETDType::valueIsValid()
     * @uses \Pcm\EnumType\PcmETAETDType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eTAETD
     * @return \Pcm\StructType\PcmEstimatedTimeOptions
     */
    public function setETAETD($eTAETD = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmETAETDType::valueIsValid($eTAETD)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eTAETD, implode(', ', \Pcm\EnumType\PcmETAETDType::getValidValues())), __LINE__);
        }
        $this->ETAETD = $eTAETD;
        return $this;
    }
    /**
     * Get DateOption value
     * @return string|null
     */
    public function getDateOption()
    {
        return $this->DateOption;
    }
    /**
     * Set DateOption value
     * @uses \Pcm\EnumType\PcmDateOption::valueIsValid()
     * @uses \Pcm\EnumType\PcmDateOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateOption
     * @return \Pcm\StructType\PcmEstimatedTimeOptions
     */
    public function setDateOption($dateOption = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDateOption::valueIsValid($dateOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dateOption, implode(', ', \Pcm\EnumType\PcmDateOption::getValidValues())), __LINE__);
        }
        $this->DateOption = $dateOption;
        return $this;
    }
    /**
     * Get DateAndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmDateTimeType|null
     */
    public function getDateAndTime()
    {
        return isset($this->DateAndTime) ? $this->DateAndTime : null;
    }
    /**
     * Set DateAndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmDateTimeType $dateAndTime
     * @return \Pcm\StructType\PcmEstimatedTimeOptions
     */
    public function setDateAndTime(\Pcm\StructType\PcmDateTimeType $dateAndTime = null)
    {
        if (is_null($dateAndTime) || (is_array($dateAndTime) && empty($dateAndTime))) {
            unset($this->DateAndTime);
        } else {
            $this->DateAndTime = $dateAndTime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmEstimatedTimeOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
