<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EngineConfig StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EngineConfig
 * @package Pcm
 * @subpackage Structs
 */
class PcmEngineConfig extends AbstractStructBase
{
    /**
     * The Hybrid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Hybrid;
    /**
     * The EmissionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmissionType;
    /**
     * The MinPollutionVeh
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MinPollutionVeh;
    /**
     * Constructor method for EngineConfig
     * @uses PcmEngineConfig::setHybrid()
     * @uses PcmEngineConfig::setEmissionType()
     * @uses PcmEngineConfig::setMinPollutionVeh()
     * @param bool $hybrid
     * @param string $emissionType
     * @param bool $minPollutionVeh
     */
    public function __construct($hybrid = null, $emissionType = null, $minPollutionVeh = null)
    {
        $this
            ->setHybrid($hybrid)
            ->setEmissionType($emissionType)
            ->setMinPollutionVeh($minPollutionVeh);
    }
    /**
     * Get Hybrid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHybrid()
    {
        return isset($this->Hybrid) ? $this->Hybrid : null;
    }
    /**
     * Set Hybrid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hybrid
     * @return \Pcm\StructType\PcmEngineConfig
     */
    public function setHybrid($hybrid = null)
    {
        // validation for constraint: boolean
        if (!is_null($hybrid) && !is_bool($hybrid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hybrid)), __LINE__);
        }
        if (is_null($hybrid) || (is_array($hybrid) && empty($hybrid))) {
            unset($this->Hybrid);
        } else {
            $this->Hybrid = $hybrid;
        }
        return $this;
    }
    /**
     * Get EmissionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmissionType()
    {
        return isset($this->EmissionType) ? $this->EmissionType : null;
    }
    /**
     * Set EmissionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pcm\EnumType\PcmEngineEmissionType::valueIsValid()
     * @uses \Pcm\EnumType\PcmEngineEmissionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $emissionType
     * @return \Pcm\StructType\PcmEngineConfig
     */
    public function setEmissionType($emissionType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmEngineEmissionType::valueIsValid($emissionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $emissionType, implode(', ', \Pcm\EnumType\PcmEngineEmissionType::getValidValues())), __LINE__);
        }
        if (is_null($emissionType) || (is_array($emissionType) && empty($emissionType))) {
            unset($this->EmissionType);
        } else {
            $this->EmissionType = $emissionType;
        }
        return $this;
    }
    /**
     * Get MinPollutionVeh value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMinPollutionVeh()
    {
        return isset($this->MinPollutionVeh) ? $this->MinPollutionVeh : null;
    }
    /**
     * Set MinPollutionVeh value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $minPollutionVeh
     * @return \Pcm\StructType\PcmEngineConfig
     */
    public function setMinPollutionVeh($minPollutionVeh = null)
    {
        // validation for constraint: boolean
        if (!is_null($minPollutionVeh) && !is_bool($minPollutionVeh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($minPollutionVeh)), __LINE__);
        }
        if (is_null($minPollutionVeh) || (is_array($minPollutionVeh) && empty($minPollutionVeh))) {
            unset($this->MinPollutionVeh);
        } else {
            $this->MinPollutionVeh = $minPollutionVeh;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmEngineConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
