<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvoidFavorSet StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AvoidFavorSet
 * @package Pcm
 * @subpackage Structs
 */
class PcmAvoidFavorSet extends AbstractStructBase
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The AvoidFavor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmAvoidFavor
     */
    public $AvoidFavor;
    /**
     * Constructor method for AvoidFavorSet
     * @uses PcmAvoidFavorSet::setAction()
     * @uses PcmAvoidFavorSet::setAvoidFavor()
     * @param string $action
     * @param \Pcm\StructType\PcmAvoidFavor $avoidFavor
     */
    public function __construct($action = null, \Pcm\StructType\PcmAvoidFavor $avoidFavor = null)
    {
        $this
            ->setAction($action)
            ->setAvoidFavor($avoidFavor);
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \Pcm\EnumType\PcmActionType::valueIsValid()
     * @uses \Pcm\EnumType\PcmActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \Pcm\StructType\PcmAvoidFavorSet
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmActionType::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \Pcm\EnumType\PcmActionType::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get AvoidFavor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmAvoidFavor|null
     */
    public function getAvoidFavor()
    {
        return isset($this->AvoidFavor) ? $this->AvoidFavor : null;
    }
    /**
     * Set AvoidFavor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmAvoidFavor $avoidFavor
     * @return \Pcm\StructType\PcmAvoidFavorSet
     */
    public function setAvoidFavor(\Pcm\StructType\PcmAvoidFavor $avoidFavor = null)
    {
        if (is_null($avoidFavor) || (is_array($avoidFavor) && empty($avoidFavor))) {
            unset($this->AvoidFavor);
        } else {
            $this->AvoidFavor = $avoidFavor;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmAvoidFavorSet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
