<?php

namespace Pcm\EnumType;

/**
 * This class stands for WeatherAlertUrgency EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WeatherAlertUrgency
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmWeatherAlertUrgency
{
    /**
     * Constant for value 'Immediate'
     * @return string 'Immediate'
     */
    const VALUE_IMMEDIATE = 'Immediate';
    /**
     * Constant for value 'Expected'
     * @return string 'Expected'
     */
    const VALUE_EXPECTED = 'Expected';
    /**
     * Constant for value 'Future'
     * @return string 'Future'
     */
    const VALUE_FUTURE = 'Future';
    /**
     * Constant for value 'Past'
     * @return string 'Past'
     */
    const VALUE_PAST = 'Past';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IMMEDIATE
     * @uses self::VALUE_EXPECTED
     * @uses self::VALUE_FUTURE
     * @uses self::VALUE_PAST
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IMMEDIATE,
            self::VALUE_EXPECTED,
            self::VALUE_FUTURE,
            self::VALUE_PAST,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
